/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.objectweb.asm.Label;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.WeavingMethodVisitor;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WeavingMethodVisitor.CatchHandler", generator="Immutables")
@Immutable
final class ImmutableCatchHandler
implements WeavingMethodVisitor.CatchHandler {
    private final Label catchStartLabel;
    private final ImmutableList<Advice> advisors;

    private ImmutableCatchHandler(Label catchStartLabel, Iterable<? extends Advice> advisors) {
        this.catchStartLabel = Objects.requireNonNull(catchStartLabel, "catchStartLabel");
        this.advisors = ImmutableList.copyOf(advisors);
    }

    private ImmutableCatchHandler(ImmutableCatchHandler original, Label catchStartLabel, ImmutableList<Advice> advisors) {
        this.catchStartLabel = catchStartLabel;
        this.advisors = advisors;
    }

    @Override
    @JsonProperty(value="catchStartLabel")
    public Label catchStartLabel() {
        return this.catchStartLabel;
    }

    @JsonProperty(value="advisors")
    public ImmutableList<Advice> advisors() {
        return this.advisors;
    }

    public final ImmutableCatchHandler withCatchStartLabel(Label value) {
        if (this.catchStartLabel == value) {
            return this;
        }
        Label newValue = Objects.requireNonNull(value, "catchStartLabel");
        return new ImmutableCatchHandler(this, newValue, this.advisors);
    }

    public final ImmutableCatchHandler withAdvisors(Advice ... elements) {
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableCatchHandler(this, this.catchStartLabel, newValue);
    }

    public final ImmutableCatchHandler withAdvisors(Iterable<? extends Advice> elements) {
        if (this.advisors == elements) {
            return this;
        }
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableCatchHandler(this, this.catchStartLabel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatchHandler && this.equalTo(0, (ImmutableCatchHandler)another);
    }

    private boolean equalTo(int synthetic, ImmutableCatchHandler another) {
        return this.catchStartLabel.equals(another.catchStartLabel) && this.advisors.equals(another.advisors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.catchStartLabel.hashCode();
        h += (h << 5) + this.advisors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CatchHandler").omitNullValues().add("catchStartLabel", this.catchStartLabel).add("advisors", this.advisors).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCatchHandler fromJson(Json json) {
        Builder builder = ImmutableCatchHandler.builder();
        if (json.catchStartLabel != null) {
            builder.catchStartLabel(json.catchStartLabel);
        }
        if (json.advisors != null) {
            builder.addAllAdvisors(json.advisors);
        }
        return builder.build();
    }

    public static ImmutableCatchHandler of(Label catchStartLabel, List<Advice> advisors) {
        return ImmutableCatchHandler.of(catchStartLabel, advisors);
    }

    public static ImmutableCatchHandler of(Label catchStartLabel, Iterable<? extends Advice> advisors) {
        return new ImmutableCatchHandler(catchStartLabel, advisors);
    }

    public static ImmutableCatchHandler copyOf(WeavingMethodVisitor.CatchHandler instance) {
        if (instance instanceof ImmutableCatchHandler) {
            return (ImmutableCatchHandler)instance;
        }
        return ImmutableCatchHandler.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WeavingMethodVisitor.CatchHandler", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CATCH_START_LABEL = 1L;
        private long initBits = 1L;
        @Nullable
        private Label catchStartLabel;
        private ImmutableList.Builder<Advice> advisors = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(WeavingMethodVisitor.CatchHandler instance) {
            Objects.requireNonNull(instance, "instance");
            this.catchStartLabel(instance.catchStartLabel());
            this.addAllAdvisors(instance.advisors());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder catchStartLabel(Label catchStartLabel) {
            this.catchStartLabel = Objects.requireNonNull(catchStartLabel, "catchStartLabel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdvisors(Advice element) {
            this.advisors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdvisors(Advice ... elements) {
            this.advisors.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder advisors(Iterable<? extends Advice> elements) {
            this.advisors = ImmutableList.builder();
            return this.addAllAdvisors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdvisors(Iterable<? extends Advice> elements) {
            this.advisors.addAll(elements);
            return this;
        }

        public ImmutableCatchHandler build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatchHandler(null, this.catchStartLabel, (ImmutableList)this.advisors.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("catchStartLabel");
            }
            return "Cannot build CatchHandler, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WeavingMethodVisitor.CatchHandler", generator="Immutables")
    static final class Json
    implements WeavingMethodVisitor.CatchHandler {
        @Nullable
        Label catchStartLabel;
        @Nullable
        List<Advice> advisors = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="catchStartLabel")
        public void setCatchStartLabel(Label catchStartLabel) {
            this.catchStartLabel = catchStartLabel;
        }

        @JsonProperty(value="advisors")
        public void setAdvisors(List<Advice> advisors) {
            this.advisors = advisors;
        }

        @Override
        public Label catchStartLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Advice> advisors() {
            throw new UnsupportedOperationException();
        }
    }
}

