/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.slf4j.impl;

import org.glowroot.agent.shaded.ch.qos.logback.classic.LoggerContext;
import org.glowroot.agent.shaded.ch.qos.logback.classic.util.ContextInitializer;
import org.glowroot.agent.shaded.ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import org.glowroot.agent.shaded.ch.qos.logback.core.joran.spi.JoranException;
import org.glowroot.agent.shaded.ch.qos.logback.core.status.StatusUtil;
import org.glowroot.agent.shaded.ch.qos.logback.core.util.StatusPrinter;
import org.glowroot.agent.shaded.org.slf4j.ILoggerFactory;
import org.glowroot.agent.shaded.org.slf4j.helpers.Util;

public class StaticLoggerBinder {
    public static String REQUESTED_API_VERSION = "1.7.16";
    private static StaticLoggerBinder SINGLETON = new StaticLoggerBinder();
    private static Object KEY = new Object();
    private boolean initialized = false;
    private LoggerContext defaultLoggerContext = new LoggerContext();
    private final ContextSelectorStaticBinder contextSelectorBinder = ContextSelectorStaticBinder.getSingleton();

    private StaticLoggerBinder() {
        this.defaultLoggerContext.setName("default");
    }

    public static StaticLoggerBinder getSingleton() {
        return SINGLETON;
    }

    void init() {
        try {
            try {
                new ContextInitializer(this.defaultLoggerContext).autoConfig();
            }
            catch (JoranException je) {
                Util.report("Failed to auto configure default logger context", je);
            }
            if (!StatusUtil.contextHasStatusListener(this.defaultLoggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(this.defaultLoggerContext);
            }
            this.contextSelectorBinder.init(this.defaultLoggerContext, KEY);
            this.initialized = true;
        }
        catch (Exception t) {
            Util.report("Failed to instantiate [" + LoggerContext.class.getName() + "]", t);
        }
    }

    public ILoggerFactory getLoggerFactory() {
        if (!this.initialized) {
            return this.defaultLoggerContext;
        }
        if (this.contextSelectorBinder.getContextSelector() == null) {
            throw new IllegalStateException("contextSelector cannot be null. See also http://logback.qos.ch/codes.html#null_CS");
        }
        return this.contextSelectorBinder.getContextSelector().getLoggerContext();
    }

    public String getLoggerFactoryClassStr() {
        return this.contextSelectorBinder.getClass().getName();
    }

    static {
        SINGLETON.init();
    }
}

