/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;

public class MutableServiceCall {
    static final Ordering<MutableServiceCall> byTotalDurationDesc = new Ordering<MutableServiceCall>(){

        @Override
        public int compare(MutableServiceCall left, MutableServiceCall right) {
            return Doubles.compare(right.totalDurationNanos, left.totalDurationNanos);
        }
    };
    private final String type;
    private final String text;
    private double totalDurationNanos;
    private long executionCount;

    MutableServiceCall(String type, String text) {
        this.type = type;
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public double getTotalDurationNanos() {
        return this.totalDurationNanos;
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    void addToTotalDurationNanos(double totalDurationNanos) {
        this.totalDurationNanos += totalDurationNanos;
    }

    void addToExecutionCount(long executionCount) {
        this.executionCount += executionCount;
    }

    void add(MutableServiceCall serviceCall) {
        this.addToTotalDurationNanos(serviceCall.totalDurationNanos);
        this.addToExecutionCount(serviceCall.executionCount);
    }
}

