/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.protobuf.lite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.protobuf.CodedInputStream;
import org.glowroot.agent.shaded.com.google.protobuf.ExtensionRegistryLite;
import org.glowroot.agent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.glowroot.agent.shaded.com.google.protobuf.MessageLite;
import org.glowroot.agent.shaded.com.google.protobuf.Parser;
import org.glowroot.agent.shaded.io.grpc.KnownLength;
import org.glowroot.agent.shaded.io.grpc.MethodDescriptor;
import org.glowroot.agent.shaded.io.grpc.MethodDescriptor$PrototypeMarshaller;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.protobuf.lite.ProtoInputStream;

public final class ProtoLiteUtils {
    static volatile ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();

    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        return new MessageMarshaller<T>(defaultInstance, -1);
    }

    static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Preconditions.checkNotNull(from, "inputStream cannot be null!");
        Preconditions.checkNotNull(to, "outputStream cannot be null!");
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    private static final class MessageMarshaller<T extends MessageLite>
    implements MethodDescriptor$PrototypeMarshaller<T> {
        private static final ThreadLocal<Reference<byte[]>> bufs = new ThreadLocal();
        private final Parser<T> parser;
        private final T defaultInstance;
        private final int recursionLimit;

        MessageMarshaller(T defaultInstance, int recursionLimit) {
            this.defaultInstance = (MessageLite)Preconditions.checkNotNull(defaultInstance, "defaultInstance cannot be null");
            this.parser = defaultInstance.getParserForType();
            this.recursionLimit = recursionLimit;
        }

        @Override
        public InputStream stream(T value) {
            return new ProtoInputStream((MessageLite)value, this.parser);
        }

        @Override
        public T parse(InputStream stream) {
            ProtoInputStream protoStream;
            if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == this.parser) {
                try {
                    MessageLite message = ((ProtoInputStream)stream).message();
                    return (T)message;
                }
                catch (IllegalStateException message) {
                    // empty catch block
                }
            }
            CodedInputStream cis = null;
            try {
                if (stream instanceof KnownLength) {
                    int size = stream.available();
                    if (size > 0 && size <= 0x400000) {
                        int position;
                        int remaining;
                        int count;
                        byte[] buf;
                        Reference<byte[]> ref = bufs.get();
                        if (ref == null || (buf = ref.get()) == null || buf.length < size) {
                            buf = new byte[size];
                            bufs.set(new WeakReference<byte[]>(buf));
                        }
                        for (remaining = size; remaining > 0 && (count = stream.read(buf, position = size - remaining, remaining)) != -1; remaining -= count) {
                        }
                        if (remaining != 0) {
                            position = size - remaining;
                            throw new RuntimeException("size inaccurate: " + size + " != " + position);
                        }
                        cis = CodedInputStream.newInstance(buf, 0, size);
                    } else if (size == 0) {
                        return this.defaultInstance;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (cis == null) {
                cis = CodedInputStream.newInstance(stream);
            }
            cis.setSizeLimit(Integer.MAX_VALUE);
            if (this.recursionLimit >= 0) {
                cis.setRecursionLimit(this.recursionLimit);
            }
            try {
                return this.parseFrom(cis);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
            }
        }

        private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
            MessageLite message = (MessageLite)this.parser.parseFrom(stream, globalRegistry);
            try {
                stream.checkLastTagWas(0);
                return (T)message;
            }
            catch (InvalidProtocolBufferException e) {
                e.setUnfinishedMessage(message);
                throw e;
            }
        }
    }
}

