/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc;

import java.net.SocketAddress;
import java.util.Collection;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.ChannelCredentials;
import org.glowroot.agent.shaded.io.grpc.ManagedChannelBuilder;

public abstract class ManagedChannelProvider {
    protected abstract boolean isAvailable();

    protected abstract int priority();

    protected NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        return NewChannelBuilderResult.error("ChannelCredentials are unsupported");
    }

    protected abstract Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes();

    public static final class NewChannelBuilderResult {
        private final ManagedChannelBuilder<?> channelBuilder;
        private final String error;

        private NewChannelBuilderResult(ManagedChannelBuilder<?> channelBuilder, String error) {
            this.channelBuilder = channelBuilder;
            this.error = error;
        }

        public static NewChannelBuilderResult channelBuilder(ManagedChannelBuilder<?> builder) {
            return new NewChannelBuilderResult(Preconditions.checkNotNull(builder), null);
        }

        public static NewChannelBuilderResult error(String error) {
            return new NewChannelBuilderResult(null, Preconditions.checkNotNull(error));
        }

        public ManagedChannelBuilder<?> getChannelBuilder() {
            return this.channelBuilder;
        }

        public String getError() {
            return this.error;
        }
    }
}

