/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.Version;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleDeserializers;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleSerializers;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleValueInstantiators;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;

public class SimpleModule
extends Module
implements Serializable {
    private static final AtomicInteger MODULE_ID_SEQ = new AtomicInteger(1);
    protected final String _name = this.getClass() == SimpleModule.class ? "SimpleModule-" + MODULE_ID_SEQ.getAndIncrement() : this.getClass().getName();
    protected final Version _version = Version.unknownVersion();
    protected final boolean _hasExplicitName;
    protected SimpleSerializers _serializers = null;
    protected SimpleDeserializers _deserializers = null;
    protected SimpleSerializers _keySerializers = null;
    protected SimpleKeyDeserializers _keyDeserializers = null;
    protected SimpleAbstractTypeResolver _abstractTypes = null;
    protected SimpleValueInstantiators _valueInstantiators = null;
    protected BeanDeserializerModifier _deserializerModifier = null;
    protected BeanSerializerModifier _serializerModifier = null;
    protected HashMap<Class<?>, Class<?>> _mixins = null;
    protected LinkedHashSet<NamedType> _subtypes = null;
    protected PropertyNamingStrategy _namingStrategy = null;

    public SimpleModule() {
        this._hasExplicitName = false;
    }

    @Override
    public Object getTypeId() {
        if (this._hasExplicitName) {
            return this._name;
        }
        if (this.getClass() == SimpleModule.class) {
            return this._name;
        }
        return super.getTypeId();
    }

    public SimpleModule setDeserializerModifier(BeanDeserializerModifier mod) {
        this._deserializerModifier = mod;
        return this;
    }

    public <T> SimpleModule addSerializer(Class<? extends T> type, JsonSerializer<T> ser) {
        this._checkNotNull(type, "type to register serializer for");
        this._checkNotNull(ser, "serializer");
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(type, ser);
        return this;
    }

    public <T> SimpleModule addAbstractTypeMapping(Class<T> superType, Class<? extends T> subType) {
        this._checkNotNull(superType, "abstract type to map");
        this._checkNotNull(subType, "concrete type to map to");
        if (this._abstractTypes == null) {
            this._abstractTypes = new SimpleAbstractTypeResolver();
        }
        this._abstractTypes = this._abstractTypes.addMapping(superType, subType);
        return this;
    }

    @Override
    public String getModuleName() {
        return this._name;
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        if (this._serializers != null) {
            context.addSerializers(this._serializers);
        }
        if (this._deserializers != null) {
            context.addDeserializers(this._deserializers);
        }
        if (this._keySerializers != null) {
            context.addKeySerializers(this._keySerializers);
        }
        if (this._keyDeserializers != null) {
            context.addKeyDeserializers(this._keyDeserializers);
        }
        if (this._abstractTypes != null) {
            context.addAbstractTypeResolver(this._abstractTypes);
        }
        if (this._valueInstantiators != null) {
            context.addValueInstantiators(this._valueInstantiators);
        }
        if (this._deserializerModifier != null) {
            context.addBeanDeserializerModifier(this._deserializerModifier);
        }
        if (this._serializerModifier != null) {
            context.addBeanSerializerModifier(this._serializerModifier);
        }
        if (this._subtypes != null && this._subtypes.size() > 0) {
            context.registerSubtypes(this._subtypes.toArray(new NamedType[this._subtypes.size()]));
        }
        if (this._namingStrategy != null) {
            context.setNamingStrategy(this._namingStrategy);
        }
        if (this._mixins != null) {
            for (Map.Entry<Class<?>, Class<?>> entry : this._mixins.entrySet()) {
                context.setMixInAnnotations(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Version version() {
        return this._version;
    }

    protected void _checkNotNull(Object thingy, String type) {
        if (thingy == null) {
            throw new IllegalArgumentException(String.format("Cannot pass `null` as %s", type));
        }
    }
}

