/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.ch.qos.logback.classic.spi;

import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ClassPackagingData;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.IThrowableProxy;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.StackTraceElementProxy;

public class ThrowableProxyUtil {
    static StackTraceElementProxy[] steArrayToStepArray(StackTraceElement[] stea) {
        if (stea == null) {
            return new StackTraceElementProxy[0];
        }
        StackTraceElementProxy[] stepa = new StackTraceElementProxy[stea.length];
        for (int i = 0; i < stepa.length; ++i) {
            stepa[i] = new StackTraceElementProxy(stea[i]);
        }
        return stepa;
    }

    static int findNumberOfCommonFrames(StackTraceElement[] steArray, StackTraceElementProxy[] parentSTEPArray) {
        StackTraceElement otherSte;
        StackTraceElement ste;
        if (parentSTEPArray == null || steArray == null) {
            return 0;
        }
        int steIndex = steArray.length - 1;
        int count = 0;
        for (int parentIndex = parentSTEPArray.length - 1; steIndex >= 0 && parentIndex >= 0 && (ste = steArray[steIndex]).equals(otherSte = parentSTEPArray[parentIndex].ste); --steIndex, --parentIndex) {
            ++count;
        }
        return count;
    }

    public static void indent(StringBuilder buf, int indent) {
        for (int j = 0; j < indent; ++j) {
            buf.append('\t');
        }
    }

    public static void subjoinPackagingData(StringBuilder builder, StackTraceElementProxy step) {
        ClassPackagingData cpd;
        if (step != null && (cpd = step.getClassPackagingData()) != null) {
            if (!cpd.isExact()) {
                builder.append(" ~[");
            } else {
                builder.append(" [");
            }
            builder.append(cpd.getCodeLocation()).append(':').append(cpd.getVersion()).append(']');
        }
    }

    public static void subjoinFirstLineRootCauseFirst(StringBuilder buf, IThrowableProxy tp) {
        if (tp.getCause() != null) {
            buf.append("Wrapped by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(buf, tp);
    }

    private static void subjoinExceptionMessage(StringBuilder buf, IThrowableProxy tp) {
        buf.append(tp.getClassName()).append(": ").append(tp.getMessage());
    }
}

