/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;

public class OkHttpCallbackWrapper
implements Callback {
    private final Callback delegate;
    private final AsyncTraceEntry asyncTraceEntry;
    private final AuxThreadContext auxContext;

    public OkHttpCallbackWrapper(Callback delegate, AsyncTraceEntry asyncTraceEntry, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.asyncTraceEntry = asyncTraceEntry;
        this.auxContext = auxContext;
    }

    public void onFailure(Call call, IOException exception) {
        this.asyncTraceEntry.endWithError(exception);
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.onFailure(call, exception);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw OkHttpCallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    public void onResponse(Call call, Response response) throws IOException {
        this.asyncTraceEntry.end();
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.onResponse(call, response);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw OkHttpCallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        OkHttpCallbackWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

