/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import org.glowroot.agent.model.SharedQueryTextCollection;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;

class MutableQuery {
    private double totalDurationNanos;
    private long executionCount;
    private boolean hasTotalRows;
    private long totalRows;
    private boolean active;

    MutableQuery() {
    }

    double getTotalDurationNanos() {
        return this.totalDurationNanos;
    }

    long getExecutionCount() {
        return this.executionCount;
    }

    boolean hasTotalRows() {
        return this.hasTotalRows;
    }

    long getTotalRows() {
        return this.totalRows;
    }

    boolean isActive() {
        return this.active;
    }

    void addToTotalDurationNanos(double totalDurationNanos) {
        this.totalDurationNanos += totalDurationNanos;
    }

    void addToExecutionCount(long executionCount) {
        this.executionCount += executionCount;
    }

    void addToTotalRows(boolean hasTotalRows, long totalRows) {
        if (hasTotalRows) {
            this.hasTotalRows = true;
            this.totalRows += totalRows;
        }
    }

    void setActive(boolean active) {
        this.active = active;
    }

    void add(MutableQuery query) {
        this.addToTotalDurationNanos(query.totalDurationNanos);
        this.addToExecutionCount(query.executionCount);
        this.addToTotalRows(query.hasTotalRows, query.totalRows);
        if (query.active) {
            this.setActive(true);
        }
    }

    void add(AggregateOuterClass.Aggregate.Query query) {
        this.addToTotalDurationNanos(query.getTotalDurationNanos());
        this.addToExecutionCount(query.getExecutionCount());
        this.addToTotalRows(query.hasTotalRows(), query.getTotalRows().getValue());
        if (query.getActive()) {
            this.setActive(true);
        }
    }

    AggregateOuterClass.Aggregate.Query toAggregateProto(String queryType, String queryText, SharedQueryTextCollection sharedQueryTextCollection, boolean includeActive) {
        int sharedQueryTextIndex = sharedQueryTextCollection.getSharedQueryTextIndex(queryText);
        AggregateOuterClass.Aggregate.Query.Builder builder = AggregateOuterClass.Aggregate.Query.newBuilder().setType(queryType).setSharedQueryTextIndex(sharedQueryTextIndex).setTotalDurationNanos(this.totalDurationNanos).setExecutionCount(this.executionCount);
        if (this.hasTotalRows) {
            builder.setTotalRows(Proto.OptionalInt64.newBuilder().setValue(this.totalRows));
        }
        if (includeActive) {
            builder.setActive(this.active);
        }
        return builder.build();
    }
}

