/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.MergedThreadTimer;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;

class RootTimerCollectorImpl
implements Transaction.RootTimerCollector {
    private final List<MergedThreadTimer> rootMutableTimers = Lists.newArrayList();

    RootTimerCollectorImpl() {
    }

    @Override
    public void mergeRootTimer(TransactionTimer rootTimer) {
        RootTimerCollectorImpl.mergeRootTimer(rootTimer, this.rootMutableTimers);
    }

    List<TraceOuterClass.Trace.Timer> toProto() {
        ArrayList<TraceOuterClass.Trace.Timer> rootTimers = Lists.newArrayList();
        for (MergedThreadTimer rootMutableTimer : this.rootMutableTimers) {
            rootTimers.add(rootMutableTimer.toProto());
        }
        return rootTimers;
    }

    List<MergedThreadTimer> getRootTimers() {
        return this.rootMutableTimers;
    }

    private static void mergeRootTimer(TransactionTimer toBeMergedRootTimer, List<MergedThreadTimer> rootTimers) {
        for (MergedThreadTimer rootTimer : rootTimers) {
            if (!toBeMergedRootTimer.getName().equals(rootTimer.getName()) || toBeMergedRootTimer.isExtended() != rootTimer.isExtended()) continue;
            rootTimer.addDataFrom(toBeMergedRootTimer);
            return;
        }
        MergedThreadTimer rootTimer = new MergedThreadTimer(toBeMergedRootTimer.getName(), toBeMergedRootTimer.isExtended());
        rootTimer.addDataFrom(toBeMergedRootTimer);
        rootTimers.add(rootTimer);
    }
}

