/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.util.HashMap;
import java.util.List;
import org.glowroot.agent.config.ImmutableAllConfig;
import org.glowroot.agent.config.PluginConfig;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.SyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AllConfig {
    abstract TransactionConfig transaction();

    abstract JvmConfig jvm();

    abstract UiDefaultsConfig uiDefaults();

    abstract AdvancedConfig advanced();

    abstract List<GaugeConfig> gauges();

    abstract List<SyntheticMonitorConfig> syntheticMonitors();

    abstract List<AlertConfig> alerts();

    abstract List<PluginConfig> plugins();

    abstract List<InstrumentationConfig> instrumentation();

    public static AllConfig create(AgentConfigOuterClass.AgentConfig config, List<PluginDescriptor> pluginDescriptors) {
        ImmutableAllConfig.Builder builder = ImmutableAllConfig.builder().transaction(TransactionConfig.create(config.getTransactionConfig())).jvm(JvmConfig.create(config.getJvmConfig())).uiDefaults(UiDefaultsConfig.create(config.getUiDefaultsConfig())).advanced(AdvancedConfig.create(config.getAdvancedConfig()));
        for (AgentConfigOuterClass.AgentConfig.GaugeConfig gaugeConfig : config.getGaugeConfigList()) {
            builder.addGauges((GaugeConfig)GaugeConfig.create(gaugeConfig));
        }
        for (AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig syntheticMonitorConfig : config.getSyntheticMonitorConfigList()) {
            builder.addSyntheticMonitors((SyntheticMonitorConfig)SyntheticMonitorConfig.create(syntheticMonitorConfig));
        }
        for (AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig : config.getAlertConfigList()) {
            builder.addAlerts((AlertConfig)AlertConfig.create(alertConfig));
        }
        HashMap<String, AgentConfigOuterClass.AgentConfig.PluginConfig> newPluginConfigs = Maps.newHashMap();
        for (AgentConfigOuterClass.AgentConfig.PluginConfig newPluginConfig : config.getPluginConfigList()) {
            newPluginConfigs.put(newPluginConfig.getId(), newPluginConfig);
        }
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            AgentConfigOuterClass.AgentConfig.PluginConfig pluginConfig = (AgentConfigOuterClass.AgentConfig.PluginConfig)newPluginConfigs.get(pluginDescriptor.id());
            List<Object> properties = Lists.newArrayList();
            properties = pluginConfig == null ? ImmutableList.of() : pluginConfig.getPropertyList();
            builder.addPlugins(PluginConfig.create(pluginDescriptor, properties));
        }
        for (AgentConfigOuterClass.AgentConfig.InstrumentationConfig instrumentationConfig : config.getInstrumentationConfigList()) {
            builder.addInstrumentation((InstrumentationConfig)InstrumentationConfig.create(instrumentationConfig));
        }
        return builder.build();
    }
}

