/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.shaded.io.netty.channel.EventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.glowroot.agent.shaded.io.netty.util.concurrent.Future;
import org.glowroot.agent.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.glowroot.agent.util.ThreadFactories;

class EventLoopGroups {
    private EventLoopGroups() {
    }

    static EventLoopGroup create(String name) {
        final ExecutorService executor = Executors.newSingleThreadExecutor(ThreadFactories.create(name));
        NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(1, executor);
        nioEventLoopGroup.terminationFuture().addListener(new GenericFutureListener<Future<Object>>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                executor.shutdown();
                if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Could not terminate executor");
                }
            }
        });
        return nioEventLoopGroup;
    }
}

