/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.weaving.ShimType;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ShimType", generator="Immutables")
@Immutable
final class ImmutableShimType
extends ShimType {
    private final Type iface;
    private final ImmutableList<String> targets;
    private final ImmutableList<Method> shimMethods;

    private ImmutableShimType(Type iface, ImmutableList<String> targets, ImmutableList<Method> shimMethods) {
        this.iface = iface;
        this.targets = targets;
        this.shimMethods = shimMethods;
    }

    @Override
    @JsonProperty(value="iface")
    Type iface() {
        return this.iface;
    }

    @Override
    @JsonProperty(value="targets")
    ImmutableList<String> targets() {
        return this.targets;
    }

    @Override
    @JsonProperty(value="shimMethods")
    ImmutableList<Method> shimMethods() {
        return this.shimMethods;
    }

    public final ImmutableShimType withIface(Type value) {
        if (this.iface == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "iface");
        return new ImmutableShimType(newValue, this.targets, this.shimMethods);
    }

    public final ImmutableShimType withTargets(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableShimType(this.iface, newValue, this.shimMethods);
    }

    public final ImmutableShimType withTargets(Iterable<String> elements) {
        if (this.targets == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableShimType(this.iface, newValue, this.shimMethods);
    }

    public final ImmutableShimType withShimMethods(Method ... elements) {
        ImmutableList<Method> newValue = ImmutableList.copyOf(elements);
        return new ImmutableShimType(this.iface, this.targets, newValue);
    }

    public final ImmutableShimType withShimMethods(Iterable<? extends Method> elements) {
        if (this.shimMethods == elements) {
            return this;
        }
        ImmutableList<Method> newValue = ImmutableList.copyOf(elements);
        return new ImmutableShimType(this.iface, this.targets, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShimType && this.equalTo(0, (ImmutableShimType)another);
    }

    private boolean equalTo(int synthetic, ImmutableShimType another) {
        return this.iface.equals(another.iface) && this.targets.equals(another.targets) && this.shimMethods.equals(another.shimMethods);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.iface.hashCode();
        h += (h << 5) + this.targets.hashCode();
        h += (h << 5) + this.shimMethods.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ShimType").omitNullValues().add("iface", this.iface).add("targets", this.targets).add("shimMethods", this.shimMethods).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableShimType fromJson(Json json) {
        Builder builder = ImmutableShimType.builder();
        if (json.iface != null) {
            builder.iface(json.iface);
        }
        if (json.targets != null) {
            builder.addAllTargets(json.targets);
        }
        if (json.shimMethods != null) {
            builder.addAllShimMethods(json.shimMethods);
        }
        return builder.build();
    }

    public static ImmutableShimType copyOf(ShimType instance) {
        if (instance instanceof ImmutableShimType) {
            return (ImmutableShimType)instance;
        }
        return ImmutableShimType.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShimType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IFACE = 1L;
        private long initBits = 1L;
        @Nullable
        private Type iface;
        private ImmutableList.Builder<String> targets = ImmutableList.builder();
        private ImmutableList.Builder<Method> shimMethods = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ShimType instance) {
            Objects.requireNonNull(instance, "instance");
            this.iface(instance.iface());
            this.addAllTargets(instance.targets());
            this.addAllShimMethods(instance.shimMethods());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder iface(Type iface) {
            this.iface = Objects.requireNonNull(iface, "iface");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTargets(String element) {
            this.targets.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTargets(String ... elements) {
            this.targets.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targets(Iterable<String> elements) {
            this.targets = ImmutableList.builder();
            return this.addAllTargets(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTargets(Iterable<String> elements) {
            this.targets.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addShimMethods(Method element) {
            this.shimMethods.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addShimMethods(Method ... elements) {
            this.shimMethods.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder shimMethods(Iterable<? extends Method> elements) {
            this.shimMethods = ImmutableList.builder();
            return this.addAllShimMethods(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllShimMethods(Iterable<? extends Method> elements) {
            this.shimMethods.addAll(elements);
            return this;
        }

        public ImmutableShimType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableShimType(this.iface, (ImmutableList)this.targets.build(), (ImmutableList)this.shimMethods.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("iface");
            }
            return "Cannot build ShimType, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ShimType", generator="Immutables")
    static final class Json
    extends ShimType {
        @Nullable
        Type iface;
        @Nullable
        ImmutableList<String> targets = ImmutableList.of();
        @Nullable
        ImmutableList<Method> shimMethods = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="iface")
        public void setIface(Type iface) {
            this.iface = iface;
        }

        @JsonProperty(value="targets")
        public void setTargets(ImmutableList<String> targets) {
            this.targets = targets;
        }

        @JsonProperty(value="shimMethods")
        public void setShimMethods(ImmutableList<Method> shimMethods) {
            this.shimMethods = shimMethods;
        }

        @Override
        Type iface() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> targets() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<Method> shimMethods() {
            throw new UnsupportedOperationException();
        }
    }
}

