/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.weaving.WeavingClassVisitor;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WeavingClassVisitor.MethodMetaGroup", generator="Immutables")
@Immutable
final class ImmutableMethodMetaGroup
implements WeavingClassVisitor.MethodMetaGroup {
    private final String methodName;
    private final Type methodReturnType;
    private final ImmutableList<Type> methodParameterTypes;
    private final int uniqueNum;
    private final ImmutableSet<Type> methodMetaTypes;

    private ImmutableMethodMetaGroup(String methodName, Type methodReturnType, ImmutableList<Type> methodParameterTypes, int uniqueNum, ImmutableSet<Type> methodMetaTypes) {
        this.methodName = methodName;
        this.methodReturnType = methodReturnType;
        this.methodParameterTypes = methodParameterTypes;
        this.uniqueNum = uniqueNum;
        this.methodMetaTypes = methodMetaTypes;
    }

    @Override
    @JsonProperty(value="methodName")
    public String methodName() {
        return this.methodName;
    }

    @Override
    @JsonProperty(value="methodReturnType")
    public Type methodReturnType() {
        return this.methodReturnType;
    }

    @Override
    @JsonProperty(value="methodParameterTypes")
    public ImmutableList<Type> methodParameterTypes() {
        return this.methodParameterTypes;
    }

    @Override
    @JsonProperty(value="uniqueNum")
    public int uniqueNum() {
        return this.uniqueNum;
    }

    @Override
    @JsonProperty(value="methodMetaTypes")
    public ImmutableSet<Type> methodMetaTypes() {
        return this.methodMetaTypes;
    }

    public final ImmutableMethodMetaGroup withMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "methodName");
        if (this.methodName.equals(newValue)) {
            return this;
        }
        return new ImmutableMethodMetaGroup(newValue, this.methodReturnType, this.methodParameterTypes, this.uniqueNum, this.methodMetaTypes);
    }

    public final ImmutableMethodMetaGroup withMethodReturnType(Type value) {
        if (this.methodReturnType == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "methodReturnType");
        return new ImmutableMethodMetaGroup(this.methodName, newValue, this.methodParameterTypes, this.uniqueNum, this.methodMetaTypes);
    }

    public final ImmutableMethodMetaGroup withMethodParameterTypes(Type ... elements) {
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMethodMetaGroup(this.methodName, this.methodReturnType, newValue, this.uniqueNum, this.methodMetaTypes);
    }

    public final ImmutableMethodMetaGroup withMethodParameterTypes(Iterable<? extends Type> elements) {
        if (this.methodParameterTypes == elements) {
            return this;
        }
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMethodMetaGroup(this.methodName, this.methodReturnType, newValue, this.uniqueNum, this.methodMetaTypes);
    }

    public final ImmutableMethodMetaGroup withUniqueNum(int value) {
        if (this.uniqueNum == value) {
            return this;
        }
        return new ImmutableMethodMetaGroup(this.methodName, this.methodReturnType, this.methodParameterTypes, value, this.methodMetaTypes);
    }

    public final ImmutableMethodMetaGroup withMethodMetaTypes(Type ... elements) {
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableMethodMetaGroup(this.methodName, this.methodReturnType, this.methodParameterTypes, this.uniqueNum, newValue);
    }

    public final ImmutableMethodMetaGroup withMethodMetaTypes(Iterable<? extends Type> elements) {
        if (this.methodMetaTypes == elements) {
            return this;
        }
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableMethodMetaGroup(this.methodName, this.methodReturnType, this.methodParameterTypes, this.uniqueNum, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMethodMetaGroup && this.equalTo(0, (ImmutableMethodMetaGroup)another);
    }

    private boolean equalTo(int synthetic, ImmutableMethodMetaGroup another) {
        return this.methodName.equals(another.methodName) && this.methodReturnType.equals(another.methodReturnType) && this.methodParameterTypes.equals(another.methodParameterTypes) && this.uniqueNum == another.uniqueNum && this.methodMetaTypes.equals(another.methodMetaTypes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.methodName.hashCode();
        h += (h << 5) + this.methodReturnType.hashCode();
        h += (h << 5) + this.methodParameterTypes.hashCode();
        h += (h << 5) + this.uniqueNum;
        h += (h << 5) + this.methodMetaTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MethodMetaGroup").omitNullValues().add("methodName", this.methodName).add("methodReturnType", this.methodReturnType).add("methodParameterTypes", this.methodParameterTypes).add("uniqueNum", this.uniqueNum).add("methodMetaTypes", this.methodMetaTypes).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMethodMetaGroup fromJson(Json json) {
        Builder builder = ImmutableMethodMetaGroup.builder();
        if (json.methodName != null) {
            builder.methodName(json.methodName);
        }
        if (json.methodReturnType != null) {
            builder.methodReturnType(json.methodReturnType);
        }
        if (json.methodParameterTypes != null) {
            builder.addAllMethodParameterTypes(json.methodParameterTypes);
        }
        if (json.uniqueNumIsSet) {
            builder.uniqueNum(json.uniqueNum);
        }
        if (json.methodMetaTypes != null) {
            builder.addAllMethodMetaTypes(json.methodMetaTypes);
        }
        return builder.build();
    }

    public static ImmutableMethodMetaGroup copyOf(WeavingClassVisitor.MethodMetaGroup instance) {
        if (instance instanceof ImmutableMethodMetaGroup) {
            return (ImmutableMethodMetaGroup)instance;
        }
        return ImmutableMethodMetaGroup.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WeavingClassVisitor.MethodMetaGroup", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METHOD_NAME = 1L;
        private static final long INIT_BIT_METHOD_RETURN_TYPE = 2L;
        private static final long INIT_BIT_UNIQUE_NUM = 4L;
        private long initBits = 7L;
        @Nullable
        private String methodName;
        @Nullable
        private Type methodReturnType;
        private ImmutableList.Builder<Type> methodParameterTypes = ImmutableList.builder();
        private int uniqueNum;
        private ImmutableSet.Builder<Type> methodMetaTypes = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(WeavingClassVisitor.MethodMetaGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.methodName(instance.methodName());
            this.methodReturnType(instance.methodReturnType());
            this.addAllMethodParameterTypes(instance.methodParameterTypes());
            this.uniqueNum(instance.uniqueNum());
            this.addAllMethodMetaTypes(instance.methodMetaTypes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methodName(String methodName) {
            this.methodName = Objects.requireNonNull(methodName, "methodName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methodReturnType(Type methodReturnType) {
            this.methodReturnType = Objects.requireNonNull(methodReturnType, "methodReturnType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMethodParameterTypes(Type element) {
            this.methodParameterTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMethodParameterTypes(Type ... elements) {
            this.methodParameterTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methodParameterTypes(Iterable<? extends Type> elements) {
            this.methodParameterTypes = ImmutableList.builder();
            return this.addAllMethodParameterTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMethodParameterTypes(Iterable<? extends Type> elements) {
            this.methodParameterTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uniqueNum(int uniqueNum) {
            this.uniqueNum = uniqueNum;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMethodMetaTypes(Type element) {
            this.methodMetaTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMethodMetaTypes(Type ... elements) {
            this.methodMetaTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methodMetaTypes(Iterable<? extends Type> elements) {
            this.methodMetaTypes = ImmutableSet.builder();
            return this.addAllMethodMetaTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMethodMetaTypes(Iterable<? extends Type> elements) {
            this.methodMetaTypes.addAll(elements);
            return this;
        }

        public ImmutableMethodMetaGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMethodMetaGroup(this.methodName, this.methodReturnType, (ImmutableList)this.methodParameterTypes.build(), this.uniqueNum, (ImmutableSet)this.methodMetaTypes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("methodName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("methodReturnType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uniqueNum");
            }
            return "Cannot build MethodMetaGroup, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WeavingClassVisitor.MethodMetaGroup", generator="Immutables")
    static final class Json
    implements WeavingClassVisitor.MethodMetaGroup {
        @Nullable
        String methodName;
        @Nullable
        Type methodReturnType;
        @Nullable
        ImmutableList<Type> methodParameterTypes = ImmutableList.of();
        int uniqueNum;
        boolean uniqueNumIsSet;
        @Nullable
        ImmutableSet<Type> methodMetaTypes = ImmutableSet.of();

        Json() {
        }

        @JsonProperty(value="methodName")
        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        @JsonProperty(value="methodReturnType")
        public void setMethodReturnType(Type methodReturnType) {
            this.methodReturnType = methodReturnType;
        }

        @JsonProperty(value="methodParameterTypes")
        public void setMethodParameterTypes(ImmutableList<Type> methodParameterTypes) {
            this.methodParameterTypes = methodParameterTypes;
        }

        @JsonProperty(value="uniqueNum")
        public void setUniqueNum(int uniqueNum) {
            this.uniqueNum = uniqueNum;
            this.uniqueNumIsSet = true;
        }

        @JsonProperty(value="methodMetaTypes")
        public void setMethodMetaTypes(ImmutableSet<Type> methodMetaTypes) {
            this.methodMetaTypes = methodMetaTypes;
        }

        @Override
        public String methodName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type methodReturnType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<Type> methodParameterTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int uniqueNum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<Type> methodMetaTypes() {
            throw new UnsupportedOperationException();
        }
    }
}

