/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.objectweb.asm.AnnotationVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.objectweb.asm.Label;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AdviceBuilder;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.ImmutableLazyDefinedClass;

class AdviceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AdviceGenerator.class);
    private static final AtomicInteger counter = new AtomicInteger();
    private final InstrumentationConfig config;
    private final @Nullable String pluginId;
    private final int priorityForSetters;
    private final String adviceInternalName;
    private final @Nullable String methodMetaInternalName;
    private final int uniqueNum;

    static ImmutableMap<Advice, ClassLoaders.LazyDefinedClass> createAdvisors(List<InstrumentationConfig> configs, @Nullable String pluginId, boolean userPlugin, boolean reweavable) {
        HashMap<Advice, ClassLoaders.LazyDefinedClass> advisors = Maps.newHashMap();
        for (InstrumentationConfig config : configs) {
            if (!config.validationErrors().isEmpty()) continue;
            try {
                ClassLoaders.LazyDefinedClass lazyAdviceClass = new AdviceGenerator(config, pluginId, userPlugin).generate();
                Advice advice = new AdviceBuilder(lazyAdviceClass, reweavable).build();
                advisors.put(advice, lazyAdviceClass);
            }
            catch (Exception e) {
                logger.error("error creating advice for advice config: {}", (Object)config, (Object)e);
            }
        }
        return ImmutableMap.copyOf(advisors);
    }

    private AdviceGenerator(InstrumentationConfig config, @Nullable String pluginId, boolean userPlugin) {
        this.config = config;
        this.pluginId = pluginId;
        this.priorityForSetters = pluginId == null ? 10000 : (userPlugin ? 100 : -100);
        this.uniqueNum = counter.incrementAndGet();
        this.adviceInternalName = "org/glowroot/agent/weaving/GeneratedAdvice" + this.uniqueNum;
        this.methodMetaInternalName = config.isTraceEntryOrGreater() || !config.transactionNameTemplate().isEmpty() || !config.transactionUserTemplate().isEmpty() || !config.transactionAttributeTemplates().isEmpty() ? "org/glowroot/agent/weaving/GeneratedMethodMeta" + this.uniqueNum : null;
    }

    private ClassLoaders.LazyDefinedClass generate() {
        ClassLoaders.LazyDefinedClass methodMetaClass = null;
        if (this.methodMetaInternalName != null) {
            methodMetaClass = this.generateMethodMetaClass(this.config);
        }
        ClassWriter cw = new ClassWriter(3);
        String[] interfaces = null;
        if (!this.config.enabledProperty().isEmpty() || !this.config.traceEntryEnabledProperty().isEmpty()) {
            interfaces = new String[]{"org/glowroot/agent/plugin/api/config/ConfigListener"};
        }
        cw.visit(49, 33, this.adviceInternalName, null, "java/lang/Object", interfaces);
        this.addClassAnnotation(cw);
        this.addStaticFields(cw);
        this.addStaticInitializer(cw);
        boolean checkNotInTransaction = this.config.isTransaction() && this.config.alreadyInTransactionBehavior() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.DO_NOTHING;
        boolean checkPropertyNotEnabled = this.pluginId != null && !this.config.enabledProperty().isEmpty();
        this.addIsEnabledMethodIfNeeded(cw, checkNotInTransaction, checkPropertyNotEnabled);
        if (this.config.isTraceEntryOrGreater()) {
            Preconditions.checkNotNull(this.methodMetaInternalName);
            this.addOnBeforeMethod(cw);
            this.addOnThrowMethod(cw);
            this.addOnReturnMethod(cw);
        } else if (this.config.captureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TIMER) {
            this.addOnBeforeMethodTimerOnly(cw);
            AdviceGenerator.addOnAfterMethodTimerOnly(cw);
        } else {
            this.addOnBeforeMethodOther(cw);
        }
        cw.visitEnd();
        ImmutableLazyDefinedClass.Builder builder = ImmutableLazyDefinedClass.builder().type(Type.getObjectType(this.adviceInternalName)).bytes(cw.toByteArray());
        if (methodMetaClass != null) {
            builder.addDependencies(methodMetaClass);
        }
        return builder.build();
    }

    private void addClassAnnotation(ClassWriter cw) {
        String nestingGroup;
        AnnotationVisitor annotationVisitor = cw.visitAnnotation("Lorg/glowroot/agent/plugin/api/weaving/Pointcut;", true);
        annotationVisitor.visit("className", this.config.className());
        annotationVisitor.visit("classAnnotation", this.config.classAnnotation());
        annotationVisitor.visit("subTypeRestriction", this.config.subTypeRestriction());
        annotationVisitor.visit("superTypeRestriction", this.config.superTypeRestriction());
        annotationVisitor.visit("methodName", this.config.methodName());
        annotationVisitor.visit("methodAnnotation", this.config.methodAnnotation());
        AnnotationVisitor arrayAnnotationVisitor = Preconditions.checkNotNull(annotationVisitor.visitArray("methodParameterTypes"));
        for (String methodParameterType : this.config.methodParameterTypes()) {
            arrayAnnotationVisitor.visit(null, methodParameterType);
        }
        arrayAnnotationVisitor.visitEnd();
        String timerName = this.config.timerName();
        if (this.config.isTimerOrGreater()) {
            if (timerName.isEmpty()) {
                annotationVisitor.visit("timerName", "<no timer name provided>");
            } else {
                annotationVisitor.visit("timerName", timerName);
            }
        }
        if (!(nestingGroup = this.config.nestingGroup()).isEmpty()) {
            annotationVisitor.visit("nestingGroup", nestingGroup);
        } else if (!this.config.traceEntryCaptureSelfNested()) {
            annotationVisitor.visit("nestingGroup", "__GeneratedAdvice" + this.uniqueNum);
        }
        annotationVisitor.visit("order", this.config.order());
        annotationVisitor.visitEnd();
    }

    private void addStaticFields(ClassWriter cw) {
        if (this.pluginId != null) {
            cw.visitField(26, "configService", "Lorg/glowroot/agent/plugin/api/config/ConfigService;", null, null).visitEnd();
        }
        if (this.config.isTimerOrGreater()) {
            cw.visitField(26, "timerName", "Lorg/glowroot/agent/plugin/api/TimerName;", null, null).visitEnd();
        }
        if (!this.config.enabledProperty().isEmpty()) {
            cw.visitField(26, "enabled", "Lorg/glowroot/agent/plugin/api/config/BooleanProperty;", null, null).visitEnd();
        }
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            cw.visitField(26, "entryEnabled", "Lorg/glowroot/agent/plugin/api/config/BooleanProperty;", null, null).visitEnd();
        }
    }

    private void addStaticInitializer(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        if (this.pluginId != null) {
            mv.visitLdcInsn(this.pluginId);
            mv.visitMethodInsn(184, "org/glowroot/agent/plugin/api/Agent", "getConfigService", "(Ljava/lang/String;)Lorg/glowroot/agent/plugin/api/config/ConfigService;", false);
            mv.visitFieldInsn(179, this.adviceInternalName, "configService", "Lorg/glowroot/agent/plugin/api/config/ConfigService;");
        }
        if (this.config.isTimerOrGreater()) {
            mv.visitLdcInsn(Type.getObjectType(this.adviceInternalName));
            mv.visitMethodInsn(184, "org/glowroot/agent/plugin/api/Agent", "getTimerName", "(Ljava/lang/Class;)Lorg/glowroot/agent/plugin/api/TimerName;", false);
            mv.visitFieldInsn(179, this.adviceInternalName, "timerName", "Lorg/glowroot/agent/plugin/api/TimerName;");
        }
        if (!this.config.enabledProperty().isEmpty() && this.pluginId != null) {
            mv.visitFieldInsn(178, this.adviceInternalName, "configService", "Lorg/glowroot/agent/plugin/api/config/ConfigService;");
            mv.visitLdcInsn(this.config.enabledProperty());
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/config/ConfigService", "getBooleanProperty", "(Ljava/lang/String;)Lorg/glowroot/agent/plugin/api/config/BooleanProperty;", true);
            mv.visitFieldInsn(179, this.adviceInternalName, "enabled", "Lorg/glowroot/agent/plugin/api/config/BooleanProperty;");
        }
        if (!this.config.traceEntryEnabledProperty().isEmpty() && this.pluginId != null) {
            mv.visitFieldInsn(178, this.adviceInternalName, "configService", "Lorg/glowroot/agent/plugin/api/config/ConfigService;");
            mv.visitLdcInsn(this.config.traceEntryEnabledProperty());
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/config/ConfigService", "getBooleanProperty", "(Ljava/lang/String;)Lorg/glowroot/agent/plugin/api/config/BooleanProperty;", true);
            mv.visitFieldInsn(179, this.adviceInternalName, "entryEnabled", "Lorg/glowroot/agent/plugin/api/config/BooleanProperty;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addIsEnabledMethodIfNeeded(ClassWriter cw, boolean checkNotInTransaction, boolean checkPropertyNotEnabled) {
        if (!checkNotInTransaction && !checkPropertyNotEnabled) {
            return;
        }
        String descriptor = checkNotInTransaction ? "(Lorg/glowroot/agent/plugin/api/OptionalThreadContext;)Z" : "()Z";
        MethodVisitor mv = cw.visitMethod(9, "isEnabled", descriptor, null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/agent/plugin/api/weaving/IsEnabled;");
        mv.visitCode();
        if (checkNotInTransaction && !checkPropertyNotEnabled) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/OptionalThreadContext", "isInTransaction", "()Z", true);
            Label returnTrueLabel = new Label();
            mv.visitJumpInsn(153, returnTrueLabel);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(returnTrueLabel);
            mv.visitInsn(4);
            mv.visitInsn(172);
        } else if (!checkNotInTransaction) {
            mv.visitFieldInsn(178, this.adviceInternalName, "enabled", "Lorg/glowroot/agent/plugin/api/config/BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/config/BooleanProperty", "value", "()Z", true);
            mv.visitInsn(172);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/OptionalThreadContext", "isInTransaction", "()Z", true);
            Label returnTrueLabel = new Label();
            mv.visitJumpInsn(153, returnTrueLabel);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitFieldInsn(178, this.adviceInternalName, "enabled", "Lorg/glowroot/agent/plugin/api/config/BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/config/BooleanProperty", "value", "()Z", true);
            mv.visitJumpInsn(154, returnTrueLabel);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(returnTrueLabel);
            mv.visitInsn(4);
            mv.visitInsn(172);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void addOnBeforeMethod(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "Lorg/glowroot/agent/plugin/api/TraceEntry;");
        mv.visitCode();
        if (!this.config.traceEntryEnabledProperty().isEmpty() && this.pluginId != null) {
            mv.visitFieldInsn(178, this.adviceInternalName, "entryEnabled", "Lorg/glowroot/agent/plugin/api/config/BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/config/BooleanProperty", "value", "()Z", true);
            Label label = new Label();
            mv.visitJumpInsn(154, label);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/agent/plugin/api/TimerName;");
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", "startTimer", "(Lorg/glowroot/agent/plugin/api/TimerName;)Lorg/glowroot/agent/plugin/api/Timer;", true);
            mv.visitInsn(176);
            mv.visitLabel(label);
        }
        mv.visitVarInsn(25, 0);
        if (this.config.isTransaction()) {
            String transactionType = this.config.transactionType();
            if (transactionType.isEmpty()) {
                mv.visitLdcInsn("<no transaction type provided>");
            } else {
                mv.visitLdcInsn(transactionType);
            }
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionNameTemplate", "()Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "getMessageText", "(Lorg/glowroot/agent/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
        }
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(182, this.methodMetaInternalName, "getMessageTemplate", "()Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "createMessageSupplier", "(Lorg/glowroot/agent/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Lorg/glowroot/agent/plugin/api/MessageSupplier;", false);
        mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/agent/plugin/api/TimerName;");
        if (this.config.isTransaction()) {
            String fieldName = this.config.alreadyInTransactionBehaviorCorrected() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.CAPTURE_NEW_TRANSACTION ? "CAPTURE_NEW_TRANSACTION" : "CAPTURE_TRACE_ENTRY";
            mv.visitFieldInsn(178, "org/glowroot/agent/plugin/api/OptionalThreadContext$AlreadyInTransactionBehavior", fieldName, "Lorg/glowroot/agent/plugin/api/OptionalThreadContext$AlreadyInTransactionBehavior;");
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/OptionalThreadContext", "startTransaction", "(Ljava/lang/String;Ljava/lang/String;Lorg/glowroot/agent/plugin/api/MessageSupplier;Lorg/glowroot/agent/plugin/api/TimerName;Lorg/glowroot/agent/plugin/api/OptionalThreadContext$AlreadyInTransactionBehavior;)Lorg/glowroot/agent/plugin/api/TraceEntry;", true);
        } else {
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", "startTraceEntry", "(Lorg/glowroot/agent/plugin/api/MessageSupplier;Lorg/glowroot/agent/plugin/api/TimerName;)Lorg/glowroot/agent/plugin/api/TraceEntry;", true);
        }
        this.addCodeForOptionalTransactionAttributes(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnBeforeMethodTimerOnly(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "Lorg/glowroot/agent/plugin/api/Timer;");
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/agent/plugin/api/TimerName;");
        mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", "startTimer", "(Lorg/glowroot/agent/plugin/api/TimerName;)Lorg/glowroot/agent/plugin/api/Timer;", true);
        this.addCodeForOptionalTransactionAttributes(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnBeforeMethodOther(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "V");
        mv.visitCode();
        this.addCodeForOptionalTransactionAttributes(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private MethodVisitor visitOnBeforeMethod(ClassWriter cw, String returnInternalName) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append("(");
        if (this.config.isTransaction()) {
            descriptor.append("Lorg/glowroot/agent/plugin/api/OptionalThreadContext;");
        } else {
            descriptor.append("Lorg/glowroot/agent/plugin/api/ThreadContext;");
        }
        if (this.methodMetaInternalName != null) {
            descriptor.append("Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;L");
            descriptor.append(this.methodMetaInternalName);
            descriptor.append(";)");
        } else {
            descriptor.append(")");
        }
        descriptor.append(returnInternalName);
        MethodVisitor mv = cw.visitMethod(9, "onBefore", descriptor.toString(), null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/agent/plugin/api/weaving/OnBefore;");
        if (this.methodMetaInternalName != null) {
            Preconditions.checkNotNull(mv.visitParameterAnnotation(1, "Lorg/glowroot/agent/plugin/api/weaving/BindReceiver;", true)).visitEnd();
            Preconditions.checkNotNull(mv.visitParameterAnnotation(2, "Lorg/glowroot/agent/plugin/api/weaving/BindMethodName;", true)).visitEnd();
            Preconditions.checkNotNull(mv.visitParameterAnnotation(3, "Lorg/glowroot/agent/plugin/api/weaving/BindParameterArray;", true)).visitEnd();
            Preconditions.checkNotNull(mv.visitParameterAnnotation(4, "Lorg/glowroot/agent/plugin/api/weaving/BindMethodMeta;", true)).visitEnd();
        }
        return mv;
    }

    private void addCodeForOptionalTransactionAttributes(MethodVisitor mv) {
        if (!this.config.transactionType().isEmpty() && !this.config.isTransaction()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionType());
            mv.visitLdcInsn(this.priorityForSetters);
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", "setTransactionType", "(Ljava/lang/String;I)V", true);
        }
        if (!this.config.transactionNameTemplate().isEmpty() && !this.config.isTransaction()) {
            this.addCodeForSetTransactionX(mv, "getTransactionNameTemplate", "setTransactionName");
        }
        if (!this.config.transactionUserTemplate().isEmpty()) {
            this.addCodeForSetTransactionX(mv, "getTransactionUserTemplate", "setTransactionUser");
        }
        int i = 0;
        for (String attrName : this.config.transactionAttributeTemplates().keySet()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(attrName);
            mv.visitVarInsn(25, 4);
            Preconditions.checkNotNull(this.methodMetaInternalName);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionAttributeTemplate" + i++, "()Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "getMessageText", "(Lorg/glowroot/agent/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", "addTransactionAttribute", "(Ljava/lang/String;Ljava/lang/String;)V", true);
        }
        Integer slowThresholdMillis = this.config.transactionSlowThresholdMillis();
        if (slowThresholdMillis != null) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(slowThresholdMillis.longValue());
            mv.visitFieldInsn(178, "java/util/concurrent/TimeUnit", "MILLISECONDS", "Ljava/util/concurrent/TimeUnit;");
            mv.visitLdcInsn(this.priorityForSetters);
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", "setTransactionSlowThreshold", "(JLjava/util/concurrent/TimeUnit;I)V", true);
        }
        if (this.config.transactionOuter()) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", "setTransactionOuter", "()V", true);
        }
    }

    private void addOnReturnMethod(ClassWriter cw) {
        boolean entryOrTimer = !this.config.traceEntryEnabledProperty().isEmpty();
        String travelerType = entryOrTimer ? "Ljava/lang/Object;" : "Lorg/glowroot/agent/plugin/api/TraceEntry;";
        MethodVisitor mv = cw.visitMethod(9, "onReturn", "(Lorg/glowroot/agent/plugin/api/weaving/OptionalReturn;" + travelerType + ")V", null, null);
        Preconditions.checkNotNull(mv.visitParameterAnnotation(0, "Lorg/glowroot/agent/plugin/api/weaving/BindOptionalReturn;", true)).visitEnd();
        Preconditions.checkNotNull(mv.visitParameterAnnotation(1, "Lorg/glowroot/agent/plugin/api/weaving/BindTraveler;", true)).visitEnd();
        int travelerParamIndex = 1;
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/agent/plugin/api/weaving/OnReturn;");
        mv.visitCode();
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            mv.visitVarInsn(25, travelerParamIndex);
            mv.visitTypeInsn(193, "org/glowroot/agent/plugin/api/TraceEntry");
            Label label = new Label();
            mv.visitJumpInsn(154, label);
            mv.visitVarInsn(25, travelerParamIndex);
            mv.visitTypeInsn(192, "org/glowroot/agent/plugin/api/Timer");
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/Timer", "stop", "()V", true);
            mv.visitInsn(177);
            mv.visitLabel(label);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/weaving/OptionalReturn", "isVoid", "()Z", true);
        Label notVoidLabel = new Label();
        Label endIfLabel = new Label();
        mv.visitJumpInsn(153, notVoidLabel);
        mv.visitLdcInsn("void");
        mv.visitJumpInsn(167, endIfLabel);
        mv.visitLabel(notVoidLabel);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/weaving/OptionalReturn", "getValue", "()Ljava/lang/Object;", true);
        mv.visitLabel(endIfLabel);
        mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "updateWithReturnValue", "(Lorg/glowroot/agent/plugin/api/TraceEntry;Ljava/lang/Object;)V", false);
        mv.visitVarInsn(25, travelerParamIndex);
        Integer stackTraceThresholdMillis = this.config.traceEntryStackThresholdMillis();
        if (stackTraceThresholdMillis == null) {
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/TraceEntry", "end", "()V", true);
        } else {
            mv.visitLdcInsn(stackTraceThresholdMillis.longValue());
            mv.visitFieldInsn(178, "java/util/concurrent/TimeUnit", "MILLISECONDS", "Ljava/util/concurrent/TimeUnit;");
            mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/TraceEntry", "endWithLocationStackTrace", "(JLjava/util/concurrent/TimeUnit;)V", true);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnThrowMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "onThrow", "(Ljava/lang/Throwable;Lorg/glowroot/agent/plugin/api/TraceEntry;)V", null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/agent/plugin/api/weaving/OnThrow;");
        Preconditions.checkNotNull(mv.visitParameterAnnotation(0, "Lorg/glowroot/agent/plugin/api/weaving/BindThrowable;", true)).visitEnd();
        Preconditions.checkNotNull(mv.visitParameterAnnotation(1, "Lorg/glowroot/agent/plugin/api/weaving/BindTraveler;", true)).visitEnd();
        mv.visitCode();
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            mv.visitVarInsn(25, 1);
            Label l0 = new Label();
            mv.visitJumpInsn(199, l0);
            mv.visitInsn(177);
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/TraceEntry", "endWithError", "(Ljava/lang/Throwable;)V", true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private ClassLoaders.LazyDefinedClass generateMethodMetaClass(InstrumentationConfig config) {
        int i;
        ClassWriter cw = new ClassWriter(3);
        cw.visit(49, 33, this.methodMetaInternalName, null, "java/lang/Object", null);
        cw.visitField(18, "messageTemplate", "Lorg/glowroot/agent/bytecode/api/MessageTemplate;", null, null).visitEnd();
        if (!config.transactionNameTemplate().isEmpty()) {
            cw.visitField(18, "transactionNameTemplate", "Lorg/glowroot/agent/bytecode/api/MessageTemplate;", null, null).visitEnd();
        }
        if (!config.transactionUserTemplate().isEmpty()) {
            cw.visitField(18, "transactionUserTemplate", "Lorg/glowroot/agent/bytecode/api/MessageTemplate;", null, null).visitEnd();
        }
        for (i = 0; i < config.transactionAttributeTemplates().size(); ++i) {
            cw.visitField(18, "transactionAttributeTemplate" + i, "Lorg/glowroot/agent/bytecode/api/MessageTemplate;", null, null).visitEnd();
        }
        this.generateMethodMetaConstructor(cw);
        this.generateMethodMetaGetter(cw, "messageTemplate", "getMessageTemplate");
        if (!config.transactionNameTemplate().isEmpty()) {
            this.generateMethodMetaGetter(cw, "transactionNameTemplate", "getTransactionNameTemplate");
        }
        if (!config.transactionUserTemplate().isEmpty()) {
            this.generateMethodMetaGetter(cw, "transactionUserTemplate", "getTransactionUserTemplate");
        }
        for (i = 0; i < config.transactionAttributeTemplates().size(); ++i) {
            this.generateMethodMetaGetter(cw, "transactionAttributeTemplate" + i, "getTransactionAttributeTemplate" + i);
        }
        cw.visitEnd();
        return ImmutableLazyDefinedClass.builder().type(Type.getObjectType(this.methodMetaInternalName)).bytes(cw.toByteArray()).build();
    }

    private void addCodeForSetTransactionX(MethodVisitor mv, String templateGetterName, String threadContextSetterName) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 4);
        Preconditions.checkNotNull(this.methodMetaInternalName);
        mv.visitMethodInsn(182, this.methodMetaInternalName, templateGetterName, "()Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "getMessageText", "(Lorg/glowroot/agent/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
        mv.visitLdcInsn(this.priorityForSetters);
        mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/ThreadContext", threadContextSetterName, "(Ljava/lang/String;I)V", true);
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void generateMethodMetaConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/glowroot/agent/plugin/api/MethodInfo;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        if (this.config.isTraceEntryOrGreater()) {
            String messageTemplate = this.config.traceEntryMessageTemplate();
            if (messageTemplate.isEmpty() && this.config.isTransaction()) {
                messageTemplate = this.config.transactionNameTemplate();
            }
            if (messageTemplate.isEmpty()) {
                mv.visitLdcInsn("<no message template provided>");
            } else {
                mv.visitLdcInsn(messageTemplate);
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/agent/plugin/api/MethodInfo;)Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
        } else {
            mv.visitInsn(1);
        }
        mv.visitFieldInsn(181, this.methodMetaInternalName, "messageTemplate", "Lorg/glowroot/agent/bytecode/api/MessageTemplate;");
        if (!this.config.transactionNameTemplate().isEmpty()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionNameTemplate());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/agent/plugin/api/MethodInfo;)Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionNameTemplate", "Lorg/glowroot/agent/bytecode/api/MessageTemplate;");
        }
        if (!this.config.transactionUserTemplate().isEmpty()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionUserTemplate());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/agent/plugin/api/MethodInfo;)Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionUserTemplate", "Lorg/glowroot/agent/bytecode/api/MessageTemplate;");
        }
        int i = 0;
        for (String attrTemplate : this.config.transactionAttributeTemplates().values()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(attrTemplate);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/agent/plugin/api/MethodInfo;)Lorg/glowroot/agent/bytecode/api/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionAttributeTemplate" + i++, "Lorg/glowroot/agent/bytecode/api/MessageTemplate;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void generateMethodMetaGetter(ClassWriter cw, String fieldName, String methodName) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "()Lorg/glowroot/agent/bytecode/api/MessageTemplate;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.methodMetaInternalName, fieldName, "Lorg/glowroot/agent/bytecode/api/MessageTemplate;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void addOnAfterMethodTimerOnly(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "onAfter", "(Lorg/glowroot/agent/plugin/api/Timer;)V", null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/agent/plugin/api/weaving/OnAfter;");
        Preconditions.checkNotNull(mv.visitParameterAnnotation(0, "Lorg/glowroot/agent/plugin/api/weaving/BindTraveler;", true)).visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/agent/plugin/api/Timer", "stop", "()V", true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void visitAnnotation(MethodVisitor mv, String descriptor) {
        AnnotationVisitor av = mv.visitAnnotation(descriptor, true);
        Preconditions.checkNotNull(av);
        av.visitEnd();
    }
}

