/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.weaving.BindClassMeta;
import org.glowroot.agent.plugin.api.weaving.BindMethodMeta;
import org.glowroot.agent.plugin.api.weaving.BindMethodName;
import org.glowroot.agent.plugin.api.weaving.BindOptionalReturn;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindParameterArray;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Method;
import org.glowroot.agent.util.MaybePatterns;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.ImmutableAdvice;
import org.glowroot.agent.weaving.ImmutableAdviceParameter;
import org.glowroot.agent.weaving.PluginClassRenamer;
import org.glowroot.agent.weaving.PluginDetail;
import org.glowroot.agent.weaving.PluginDetailBuilder;

class AdviceBuilder {
    private static final Type IsEnabledType = Type.getType(IsEnabled.class);
    private static final Type OnBeforeType = Type.getType(OnBefore.class);
    private static final Type OnReturnType = Type.getType(OnReturn.class);
    private static final Type OnThrowType = Type.getType(OnThrow.class);
    private static final Type OnAfterType = Type.getType(OnAfter.class);
    private static final Type ThreadContextType = Type.getType(ThreadContext.class);
    private static final Type OptionalThreadContextType = Type.getType(OptionalThreadContext.class);
    private static final Type BindReceiverType = Type.getType(BindReceiver.class);
    private static final Type BindParameterType = Type.getType(BindParameter.class);
    private static final Type BindParameterArrayType = Type.getType(BindParameterArray.class);
    private static final Type BindMethodNameType = Type.getType(BindMethodName.class);
    private static final Type BindReturnType = Type.getType(BindReturn.class);
    private static final Type BindOptionalReturnType = Type.getType(BindOptionalReturn.class);
    private static final Type BindThrowableType = Type.getType(BindThrowable.class);
    private static final Type BindTravelerType = Type.getType(BindTraveler.class);
    private static final Type BindClassMetaType = Type.getType(BindClassMeta.class);
    private static final Type BindMethodMetaType = Type.getType(BindMethodMeta.class);
    private static final Type StringType = Type.getType(String.class);
    private static final Type ThrowableType = Type.getType(Throwable.class);
    private static final ImmutableList<Type> isEnabledBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableList<Type> onBeforeBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableList<Type> onReturnBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindReturnType, BindOptionalReturnType, BindTravelerType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableList<Type> onThrowBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindThrowableType, BindTravelerType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableList<Type> onAfterBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindTravelerType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableMap<Type, Advice.ParameterKind> parameterKindMap = new ImmutableMap.Builder<Type, Advice.ParameterKind>().put(BindReceiverType, Advice.ParameterKind.RECEIVER).put(BindParameterType, Advice.ParameterKind.METHOD_ARG).put(BindParameterArrayType, Advice.ParameterKind.METHOD_ARG_ARRAY).put(BindMethodNameType, Advice.ParameterKind.METHOD_NAME).put(BindReturnType, Advice.ParameterKind.RETURN).put(BindOptionalReturnType, Advice.ParameterKind.OPTIONAL_RETURN).put(BindThrowableType, Advice.ParameterKind.THROWABLE).put(BindTravelerType, Advice.ParameterKind.TRAVELER).put(BindClassMetaType, Advice.ParameterKind.CLASS_META).put(BindMethodMetaType, Advice.ParameterKind.METHOD_META).build();
    private final ImmutableAdvice.Builder builder = ImmutableAdvice.builder();
    private final  @Nullable PluginDetail.PointcutClass adviceClass;
    private final  @Nullable ClassLoaders.LazyDefinedClass lazyAdviceClass;
    private boolean hasIsEnabledAdvice;
    private boolean hasOnBeforeAdvice;
    private boolean hasOnReturnAdvice;
    private boolean hasOnThrowAdvice;
    private boolean hasOnAfterAdvice;

    AdviceBuilder(PluginDetail.PointcutClass adviceClass) {
        this.adviceClass = adviceClass;
        this.lazyAdviceClass = null;
        this.builder.reweavable(false);
    }

    AdviceBuilder(ClassLoaders.LazyDefinedClass lazyAdviceClass, boolean reweavable) {
        this.adviceClass = null;
        this.lazyAdviceClass = lazyAdviceClass;
        this.builder.reweavable(reweavable);
    }

    Advice build() throws Exception {
        PluginDetail.PointcutClass adviceClass = this.adviceClass;
        if (adviceClass == null) {
            Preconditions.checkNotNull(this.lazyAdviceClass);
            adviceClass = PluginDetailBuilder.buildAdviceClass(this.lazyAdviceClass.bytes());
        }
        Pointcut pointcut = adviceClass.pointcut();
        Preconditions.checkNotNull(pointcut, "Class has no @Pointcut annotation");
        this.builder.pointcut(pointcut);
        this.builder.adviceType(adviceClass.type());
        this.builder.pointcutClassNamePattern(MaybePatterns.buildPattern(pointcut.className()));
        this.builder.pointcutClassAnnotationPattern(MaybePatterns.buildPattern(pointcut.classAnnotation()));
        this.builder.pointcutSubTypeRestrictionPattern(MaybePatterns.buildPattern(pointcut.subTypeRestriction()));
        this.builder.pointcutSuperTypeRestrictionPattern(MaybePatterns.buildPattern(pointcut.superTypeRestriction()));
        this.builder.pointcutMethodNamePattern(MaybePatterns.buildPattern(pointcut.methodName()));
        this.builder.pointcutMethodAnnotationPattern(MaybePatterns.buildPattern(pointcut.methodAnnotation()));
        this.builder.pointcutMethodParameterTypes(AdviceBuilder.buildPatterns(pointcut.methodParameterTypes()));
        this.builder.hasBindThreadContext(false);
        this.builder.hasBindOptionalThreadContext(false);
        for (PluginDetail.PointcutMethod adviceMethod : adviceClass.methods()) {
            if (adviceMethod.annotationTypes().contains(IsEnabledType)) {
                this.initIsEnabledAdvice(adviceClass, adviceMethod);
                continue;
            }
            if (adviceMethod.annotationTypes().contains(OnBeforeType)) {
                this.initOnBeforeAdvice(adviceClass, adviceMethod);
                continue;
            }
            if (adviceMethod.annotationTypes().contains(OnReturnType)) {
                this.initOnReturnAdvice(adviceClass, adviceMethod);
                continue;
            }
            if (adviceMethod.annotationTypes().contains(OnThrowType)) {
                this.initOnThrowAdvice(adviceClass, adviceMethod);
                continue;
            }
            if (!adviceMethod.annotationTypes().contains(OnAfterType)) continue;
            this.initOnAfterAdvice(adviceClass, adviceMethod);
        }
        if (adviceClass.collocateInClassLoader()) {
            PluginClassRenamer pluginClassRenamer = new PluginClassRenamer(adviceClass);
            this.builder.nonBootstrapLoaderAdviceClass(pluginClassRenamer.buildNonBootstrapLoaderAdviceClass());
            this.builder.nonBootstrapLoaderAdvice(pluginClassRenamer.buildNonBootstrapLoaderAdvice(this.builder.build()));
        }
        ImmutableAdvice advice = this.builder.build();
        if (pointcut.methodName().equals("<init>") && ((Advice)advice).onBeforeAdvice() != null && ((Advice)advice).hasBindOptionalThreadContext()) {
            throw new IllegalStateException("@BindOptionalThreadContext is not allowed in a @Pointcut with methodName \"<init>\" that has an @OnBefore method");
        }
        if (pointcut.methodName().equals("<init>") && ((Advice)advice).isEnabledAdvice() != null) {
            for (Advice.AdviceParameter parameter : ((Advice)advice).isEnabledParameters()) {
                if (parameter.kind() != Advice.ParameterKind.RECEIVER) continue;
                throw new IllegalStateException("@BindReceiver is not allowed on @IsEnabled for a @Pointcut with methodName \"<init>\"");
            }
        }
        return advice;
    }

    private void initIsEnabledAdvice(PluginDetail.PointcutClass adviceClass, PluginDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasIsEnabledAdvice, "@Pointcut '" + adviceClass.type().getClassName() + "' has more than one @IsEnabled method");
        Method asmMethod = adviceMethod.toAsmMethod();
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 1, "@IsEnabled method must return boolean");
        this.builder.isEnabledAdvice(asmMethod);
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.parameterAnnotationTypes(), asmMethod.getArgumentTypes(), isEnabledBindAnnotationTypes, IsEnabledType);
        this.builder.addAllIsEnabledParameters(parameters);
        this.hasIsEnabledAdvice = true;
    }

    private void initOnBeforeAdvice(PluginDetail.PointcutClass adviceClass, PluginDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnBeforeAdvice, "@Pointcut '" + adviceClass.type().getClassName() + "' has more than one @OnBefore method");
        Method asmMethod = adviceMethod.toAsmMethod();
        this.builder.onBeforeAdvice(asmMethod);
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.parameterAnnotationTypes(), asmMethod.getArgumentTypes(), onBeforeBindAnnotationTypes, OnBeforeType);
        this.builder.addAllOnBeforeParameters(parameters);
        if (asmMethod.getReturnType().getSort() != 0) {
            this.builder.travelerType(asmMethod.getReturnType());
        }
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnBeforeAdvice = true;
    }

    private void initOnReturnAdvice(PluginDetail.PointcutClass adviceClass, PluginDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnReturnAdvice, "@Pointcut '" + adviceClass.type().getClassName() + "' has more than one @OnReturn method");
        Method asmMethod = adviceMethod.toAsmMethod();
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.parameterAnnotationTypes(), asmMethod.getArgumentTypes(), onReturnBindAnnotationTypes, OnReturnType);
        for (int i = 1; i < parameters.size(); ++i) {
            AdviceBuilder.checkState(parameters.get(i).kind() != Advice.ParameterKind.RETURN, "@BindReturn must be the first argument to @OnReturn");
            AdviceBuilder.checkState(parameters.get(i).kind() != Advice.ParameterKind.OPTIONAL_RETURN, "@BindOptionalReturn must be the first argument to @OnReturn");
        }
        this.builder.onReturnAdvice(asmMethod);
        this.builder.addAllOnReturnParameters(parameters);
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnReturnAdvice = true;
    }

    private void initOnThrowAdvice(PluginDetail.PointcutClass adviceClass, PluginDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnThrowAdvice, "@Pointcut '" + adviceClass.type().getClassName() + "' has more than one @OnThrow method");
        Method asmMethod = adviceMethod.toAsmMethod();
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.parameterAnnotationTypes(), asmMethod.getArgumentTypes(), onThrowBindAnnotationTypes, OnThrowType);
        for (int i = 1; i < parameters.size(); ++i) {
            AdviceBuilder.checkState(parameters.get(i).kind() != Advice.ParameterKind.THROWABLE, "@BindThrowable must be the first argument to @OnThrow");
        }
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 0, "@OnThrow method must return void (for now)");
        this.builder.onThrowAdvice(asmMethod);
        this.builder.addAllOnThrowParameters(parameters);
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnThrowAdvice = true;
    }

    private void initOnAfterAdvice(PluginDetail.PointcutClass adviceClass, PluginDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnAfterAdvice, "@Pointcut '" + adviceClass.type().getClassName() + "' has more than one @OnAfter method");
        Method asmMethod = adviceMethod.toAsmMethod();
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 0, "@OnAfter method must return void");
        this.builder.onAfterAdvice(asmMethod);
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.parameterAnnotationTypes(), asmMethod.getArgumentTypes(), onAfterBindAnnotationTypes, OnAfterType);
        this.builder.addAllOnAfterParameters(parameters);
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnAfterAdvice = true;
    }

    private void checkForBindThreadContext(List<Advice.AdviceParameter> parameters) {
        for (Advice.AdviceParameter parameter : parameters) {
            if (parameter.kind() != Advice.ParameterKind.THREAD_CONTEXT) continue;
            this.builder.hasBindThreadContext(true);
            return;
        }
    }

    private void checkForBindOptionalThreadContext(List<Advice.AdviceParameter> parameters) {
        for (Advice.AdviceParameter parameter : parameters) {
            if (parameter.kind() != Advice.ParameterKind.OPTIONAL_THREAD_CONTEXT) continue;
            this.builder.hasBindOptionalThreadContext(true);
            break;
        }
    }

    private static void checkState(boolean condition, String message) throws AdviceConstructionException {
        if (!condition) {
            throw new AdviceConstructionException(message);
        }
    }

    private static List<Object> buildPatterns(String[] maybePatterns) {
        ArrayList<Object> patterns = Lists.newArrayList();
        for (String maybePattern : maybePatterns) {
            Pattern pattern = MaybePatterns.buildPattern(maybePattern);
            if (pattern == null) {
                patterns.add(maybePattern);
                continue;
            }
            patterns.add(pattern);
        }
        return patterns;
    }

    private static List<Advice.AdviceParameter> getAdviceParameters(Map<Integer, List<Type>> parameterAnnotationTypes, Type[] parameterTypes, List<Type> validBindAnnotationTypes, Type adviceAnnotationType) throws AdviceConstructionException {
        ArrayList<Advice.AdviceParameter> parameters = Lists.newArrayList();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].equals(ThreadContextType)) {
                parameters.add(ImmutableAdviceParameter.builder().kind(Advice.ParameterKind.THREAD_CONTEXT).type(ThreadContextType).build());
                continue;
            }
            if (parameterTypes[i].equals(OptionalThreadContextType)) {
                parameters.add(ImmutableAdviceParameter.builder().kind(Advice.ParameterKind.OPTIONAL_THREAD_CONTEXT).type(OptionalThreadContextType).build());
                continue;
            }
            Type validBindAnnotationType = AdviceBuilder.getValidBindAnnotationType(Preconditions.checkNotNull(parameterAnnotationTypes.get(i)), validBindAnnotationTypes);
            if (validBindAnnotationType == null) {
                ArrayList<String> validBindAnnotationNames = Lists.newArrayList();
                for (Type annotationType : validBindAnnotationTypes) {
                    validBindAnnotationNames.add("@" + annotationType.getClassName());
                }
                throw new AdviceConstructionException("All parameters to @" + adviceAnnotationType.getClassName() + " must be annotated with one of " + Joiner.on(", ").join(validBindAnnotationNames));
            }
            parameters.add(AdviceBuilder.getAdviceParameter(validBindAnnotationType, parameterTypes[i]));
        }
        return parameters;
    }

    private static @Nullable Type getValidBindAnnotationType(List<Type> parameterAnnotationTypes, List<Type> validBindAnnotationTypes) throws AdviceConstructionException {
        Type foundBindAnnotationType = null;
        for (Type annotationType : parameterAnnotationTypes) {
            if (!parameterKindMap.containsKey(annotationType)) continue;
            AdviceBuilder.checkState(foundBindAnnotationType == null, "Multiple annotations found on a single parameter");
            AdviceBuilder.checkState(validBindAnnotationTypes.contains(annotationType), "Annotation '" + annotationType.getClassName() + "' found in an invalid location");
            foundBindAnnotationType = annotationType;
        }
        return foundBindAnnotationType;
    }

    private static Advice.AdviceParameter getAdviceParameter(Type validBindAnnotationType, Type parameterType) throws AdviceConstructionException {
        AdviceBuilder.checkState(!validBindAnnotationType.equals(BindMethodNameType) || parameterType.equals(StringType), "@BindMethodName parameter type must be java.lang.String");
        AdviceBuilder.checkState(!validBindAnnotationType.equals(BindThrowableType) || parameterType.equals(ThrowableType), "@BindMethodName parameter type must be java.lang.Throwable");
        Advice.ParameterKind parameterKind = parameterKindMap.get(validBindAnnotationType);
        Preconditions.checkNotNull(parameterKind, "Annotation not found in parameterKindMap: " + validBindAnnotationType.getClassName());
        return ImmutableAdviceParameter.builder().kind(parameterKind).type(parameterType).build();
    }

    private static class AdviceConstructionException
    extends Exception {
        private AdviceConstructionException(@Nullable String message) {
            super(message);
        }
    }
}

