/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LiveTraceRepository.TracePoint", generator="Immutables")
@Immutable
public final class ImmutableTracePoint
implements LiveTraceRepository.TracePoint {
    private final String agentId;
    private final String traceId;
    private final long captureTime;
    private final long durationNanos;
    private final boolean partial;
    private final boolean error;
    private final boolean checkLiveTraces;

    private ImmutableTracePoint(String agentId, String traceId, long captureTime, long durationNanos, boolean partial, boolean error, boolean checkLiveTraces) {
        this.agentId = agentId;
        this.traceId = traceId;
        this.captureTime = captureTime;
        this.durationNanos = durationNanos;
        this.partial = partial;
        this.error = error;
        this.checkLiveTraces = checkLiveTraces;
    }

    @Override
    @JsonProperty(value="agentId")
    public String agentId() {
        return this.agentId;
    }

    @Override
    @JsonProperty(value="traceId")
    public String traceId() {
        return this.traceId;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="durationNanos")
    public long durationNanos() {
        return this.durationNanos;
    }

    @Override
    @JsonProperty(value="partial")
    public boolean partial() {
        return this.partial;
    }

    @Override
    @JsonProperty(value="error")
    public boolean error() {
        return this.error;
    }

    @Override
    @JsonProperty(value="checkLiveTraces")
    public boolean checkLiveTraces() {
        return this.checkLiveTraces;
    }

    public final ImmutableTracePoint withAgentId(String value) {
        String newValue = Objects.requireNonNull(value, "agentId");
        if (this.agentId.equals(newValue)) {
            return this;
        }
        return new ImmutableTracePoint(newValue, this.traceId, this.captureTime, this.durationNanos, this.partial, this.error, this.checkLiveTraces);
    }

    public final ImmutableTracePoint withTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "traceId");
        if (this.traceId.equals(newValue)) {
            return this;
        }
        return new ImmutableTracePoint(this.agentId, newValue, this.captureTime, this.durationNanos, this.partial, this.error, this.checkLiveTraces);
    }

    public final ImmutableTracePoint withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        return new ImmutableTracePoint(this.agentId, this.traceId, value, this.durationNanos, this.partial, this.error, this.checkLiveTraces);
    }

    public final ImmutableTracePoint withDurationNanos(long value) {
        if (this.durationNanos == value) {
            return this;
        }
        return new ImmutableTracePoint(this.agentId, this.traceId, this.captureTime, value, this.partial, this.error, this.checkLiveTraces);
    }

    public final ImmutableTracePoint withPartial(boolean value) {
        if (this.partial == value) {
            return this;
        }
        return new ImmutableTracePoint(this.agentId, this.traceId, this.captureTime, this.durationNanos, value, this.error, this.checkLiveTraces);
    }

    public final ImmutableTracePoint withError(boolean value) {
        if (this.error == value) {
            return this;
        }
        return new ImmutableTracePoint(this.agentId, this.traceId, this.captureTime, this.durationNanos, this.partial, value, this.checkLiveTraces);
    }

    public final ImmutableTracePoint withCheckLiveTraces(boolean value) {
        if (this.checkLiveTraces == value) {
            return this;
        }
        return new ImmutableTracePoint(this.agentId, this.traceId, this.captureTime, this.durationNanos, this.partial, this.error, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTracePoint && this.equalTo(0, (ImmutableTracePoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableTracePoint another) {
        return this.agentId.equals(another.agentId) && this.traceId.equals(another.traceId) && this.captureTime == another.captureTime && this.durationNanos == another.durationNanos && this.partial == another.partial && this.error == another.error && this.checkLiveTraces == another.checkLiveTraces;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.agentId.hashCode();
        h += (h << 5) + this.traceId.hashCode();
        h += (h << 5) + Longs.hashCode(this.captureTime);
        h += (h << 5) + Longs.hashCode(this.durationNanos);
        h += (h << 5) + Booleans.hashCode(this.partial);
        h += (h << 5) + Booleans.hashCode(this.error);
        h += (h << 5) + Booleans.hashCode(this.checkLiveTraces);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TracePoint").omitNullValues().add("agentId", this.agentId).add("traceId", this.traceId).add("captureTime", this.captureTime).add("durationNanos", this.durationNanos).add("partial", this.partial).add("error", this.error).add("checkLiveTraces", this.checkLiveTraces).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTracePoint fromJson(Json json) {
        Builder builder = ImmutableTracePoint.builder();
        if (json.agentId != null) {
            builder.agentId(json.agentId);
        }
        if (json.traceId != null) {
            builder.traceId(json.traceId);
        }
        if (json.captureTimeIsSet) {
            builder.captureTime(json.captureTime);
        }
        if (json.durationNanosIsSet) {
            builder.durationNanos(json.durationNanos);
        }
        if (json.partialIsSet) {
            builder.partial(json.partial);
        }
        if (json.errorIsSet) {
            builder.error(json.error);
        }
        if (json.checkLiveTracesIsSet) {
            builder.checkLiveTraces(json.checkLiveTraces);
        }
        return builder.build();
    }

    public static ImmutableTracePoint copyOf(LiveTraceRepository.TracePoint instance) {
        if (instance instanceof ImmutableTracePoint) {
            return (ImmutableTracePoint)instance;
        }
        return ImmutableTracePoint.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LiveTraceRepository.TracePoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AGENT_ID = 1L;
        private static final long INIT_BIT_TRACE_ID = 2L;
        private static final long INIT_BIT_CAPTURE_TIME = 4L;
        private static final long INIT_BIT_DURATION_NANOS = 8L;
        private static final long INIT_BIT_PARTIAL = 16L;
        private static final long INIT_BIT_ERROR = 32L;
        private static final long INIT_BIT_CHECK_LIVE_TRACES = 64L;
        private long initBits = 127L;
        @Nullable
        private String agentId;
        @Nullable
        private String traceId;
        private long captureTime;
        private long durationNanos;
        private boolean partial;
        private boolean error;
        private boolean checkLiveTraces;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LiveTraceRepository.TracePoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.agentId(instance.agentId());
            this.traceId(instance.traceId());
            this.captureTime(instance.captureTime());
            this.durationNanos(instance.durationNanos());
            this.partial(instance.partial());
            this.error(instance.error());
            this.checkLiveTraces(instance.checkLiveTraces());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder agentId(String agentId) {
            this.agentId = Objects.requireNonNull(agentId, "agentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder traceId(String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder durationNanos(long durationNanos) {
            this.durationNanos = durationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partial(boolean partial) {
            this.partial = partial;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(boolean error) {
            this.error = error;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder checkLiveTraces(boolean checkLiveTraces) {
            this.checkLiveTraces = checkLiveTraces;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableTracePoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTracePoint(this.agentId, this.traceId, this.captureTime, this.durationNanos, this.partial, this.error, this.checkLiveTraces);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("agentId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("traceId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("captureTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("durationNanos");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("partial");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("checkLiveTraces");
            }
            return "Cannot build TracePoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LiveTraceRepository.TracePoint", generator="Immutables")
    static final class Json
    implements LiveTraceRepository.TracePoint {
        @Nullable
        String agentId;
        @Nullable
        String traceId;
        long captureTime;
        boolean captureTimeIsSet;
        long durationNanos;
        boolean durationNanosIsSet;
        boolean partial;
        boolean partialIsSet;
        boolean error;
        boolean errorIsSet;
        boolean checkLiveTraces;
        boolean checkLiveTracesIsSet;

        Json() {
        }

        @JsonProperty(value="agentId")
        public void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @JsonProperty(value="traceId")
        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @JsonProperty(value="captureTime")
        public void setCaptureTime(long captureTime) {
            this.captureTime = captureTime;
            this.captureTimeIsSet = true;
        }

        @JsonProperty(value="durationNanos")
        public void setDurationNanos(long durationNanos) {
            this.durationNanos = durationNanos;
            this.durationNanosIsSet = true;
        }

        @JsonProperty(value="partial")
        public void setPartial(boolean partial) {
            this.partial = partial;
            this.partialIsSet = true;
        }

        @JsonProperty(value="error")
        public void setError(boolean error) {
            this.error = error;
            this.errorIsSet = true;
        }

        @JsonProperty(value="checkLiveTraces")
        public void setCheckLiveTraces(boolean checkLiveTraces) {
            this.checkLiveTraces = checkLiveTraces;
            this.checkLiveTracesIsSet = true;
        }

        @Override
        public String agentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String traceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long captureTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long durationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean partial() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean error() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean checkLiveTraces() {
            throw new UnsupportedOperationException();
        }
    }
}

