/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionConfig.SlowThresholdOverride", generator="Immutables")
@Immutable
public final class ImmutableSlowThresholdOverride
extends TransactionConfig.SlowThresholdOverride {
    private final String transactionType;
    private final String transactionName;
    private final String user;
    private final int thresholdMillis;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSlowThresholdOverride(Builder builder) {
        this.transactionType = builder.transactionType;
        this.thresholdMillis = builder.thresholdMillis;
        if (builder.transactionName != null) {
            this.initShim.transactionName(builder.transactionName);
        }
        if (builder.user != null) {
            this.initShim.user(builder.user);
        }
        this.transactionName = this.initShim.transactionName();
        this.user = this.initShim.user();
        this.initShim = null;
    }

    private ImmutableSlowThresholdOverride(String transactionType, String transactionName, String user, int thresholdMillis) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.user = user;
        this.thresholdMillis = thresholdMillis;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String transactionName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transactionName() : this.transactionName;
    }

    @Override
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String user() {
        InitShim shim = this.initShim;
        return shim != null ? shim.user() : this.user;
    }

    @Override
    @JsonProperty(value="thresholdMillis")
    public int thresholdMillis() {
        return this.thresholdMillis;
    }

    public final ImmutableSlowThresholdOverride withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableSlowThresholdOverride(newValue, this.transactionName, this.user, this.thresholdMillis);
    }

    public final ImmutableSlowThresholdOverride withTransactionName(String value) {
        String newValue = Objects.requireNonNull(value, "transactionName");
        if (this.transactionName.equals(newValue)) {
            return this;
        }
        return new ImmutableSlowThresholdOverride(this.transactionType, newValue, this.user, this.thresholdMillis);
    }

    public final ImmutableSlowThresholdOverride withUser(String value) {
        String newValue = Objects.requireNonNull(value, "user");
        if (this.user.equals(newValue)) {
            return this;
        }
        return new ImmutableSlowThresholdOverride(this.transactionType, this.transactionName, newValue, this.thresholdMillis);
    }

    public final ImmutableSlowThresholdOverride withThresholdMillis(int value) {
        if (this.thresholdMillis == value) {
            return this;
        }
        return new ImmutableSlowThresholdOverride(this.transactionType, this.transactionName, this.user, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSlowThresholdOverride && this.equalTo(0, (ImmutableSlowThresholdOverride)another);
    }

    private boolean equalTo(int synthetic, ImmutableSlowThresholdOverride another) {
        return this.transactionType.equals(another.transactionType) && this.transactionName.equals(another.transactionName) && this.user.equals(another.user) && this.thresholdMillis == another.thresholdMillis;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + this.transactionName.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.thresholdMillis;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SlowThresholdOverride").omitNullValues().add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("user", this.user).add("thresholdMillis", this.thresholdMillis).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSlowThresholdOverride fromJson(Json json) {
        Builder builder = ImmutableSlowThresholdOverride.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.thresholdMillisIsSet) {
            builder.thresholdMillis(json.thresholdMillis);
        }
        return builder.build();
    }

    public static ImmutableSlowThresholdOverride copyOf(TransactionConfig.SlowThresholdOverride instance) {
        if (instance instanceof ImmutableSlowThresholdOverride) {
            return (ImmutableSlowThresholdOverride)instance;
        }
        return ImmutableSlowThresholdOverride.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionConfig.SlowThresholdOverride", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_THRESHOLD_MILLIS = 2L;
        private long initBits = 3L;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        @Nullable
        private String user;
        private int thresholdMillis;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionConfig.SlowThresholdOverride instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionType(instance.transactionType());
            this.transactionName(instance.transactionName());
            this.user(instance.user());
            this.thresholdMillis(instance.thresholdMillis());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(String transactionName) {
            this.transactionName = Objects.requireNonNull(transactionName, "transactionName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(String user) {
            this.user = Objects.requireNonNull(user, "user");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder thresholdMillis(int thresholdMillis) {
            this.thresholdMillis = thresholdMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSlowThresholdOverride build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSlowThresholdOverride(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("thresholdMillis");
            }
            return "Cannot build SlowThresholdOverride, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionConfig.SlowThresholdOverride", generator="Immutables")
    static final class Json
    extends TransactionConfig.SlowThresholdOverride {
        @Nullable
        String transactionType;
        @Nullable
        String transactionName;
        @Nullable
        String user;
        int thresholdMillis;
        boolean thresholdMillisIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setTransactionName(String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="user")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setUser(String user) {
            this.user = user;
        }

        @JsonProperty(value="thresholdMillis")
        public void setThresholdMillis(int thresholdMillis) {
            this.thresholdMillis = thresholdMillis;
            this.thresholdMillisIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int thresholdMillis() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="TransactionConfig.SlowThresholdOverride", generator="Immutables")
    private final class InitShim {
        private byte transactionNameBuildStage = 0;
        private String transactionName;
        private byte userBuildStage = 0;
        private String user;

        private InitShim() {
        }

        String transactionName() {
            if (this.transactionNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transactionNameBuildStage == 0) {
                this.transactionNameBuildStage = (byte)-1;
                this.transactionName = Objects.requireNonNull(ImmutableSlowThresholdOverride.super.transactionName(), "transactionName");
                this.transactionNameBuildStage = 1;
            }
            return this.transactionName;
        }

        void transactionName(String transactionName) {
            this.transactionName = transactionName;
            this.transactionNameBuildStage = 1;
        }

        String user() {
            if (this.userBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userBuildStage == 0) {
                this.userBuildStage = (byte)-1;
                this.user = Objects.requireNonNull(ImmutableSlowThresholdOverride.super.user(), "user");
                this.userBuildStage = 1;
            }
            return this.user;
        }

        void user(String user) {
            this.user = user;
            this.userBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.transactionNameBuildStage == -1) {
                attributes.add("transactionName");
            }
            if (this.userBuildStage == -1) {
                attributes.add("user");
            }
            return "Cannot build SlowThresholdOverride, attribute initializers form cycle " + attributes;
        }
    }
}

