/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.HdrHistogram;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.glowroot.agent.shaded.org.HdrHistogram.AbstractHistogram;

public class Histogram
extends AbstractHistogram {
    long totalCount;
    long[] counts;
    int normalizingIndexOffset;

    @Override
    long getCountAtIndex(int index) {
        return this.counts[this.normalizeIndex(index, this.normalizingIndexOffset, this.countsArrayLength)];
    }

    @Override
    void incrementCountAtIndex(int index) {
        int n = this.normalizeIndex(index, this.normalizingIndexOffset, this.countsArrayLength);
        this.counts[n] = this.counts[n] + 1L;
    }

    @Override
    void addToCountAtIndex(int index, long value) {
        int n = this.normalizeIndex(index, this.normalizingIndexOffset, this.countsArrayLength);
        this.counts[n] = this.counts[n] + value;
    }

    @Override
    void setCountAtIndex(int index, long value) {
        this.counts[this.normalizeIndex((int)index, (int)this.normalizingIndexOffset, (int)this.countsArrayLength)] = value;
    }

    @Override
    int getNormalizingIndexOffset() {
        return this.normalizingIndexOffset;
    }

    @Override
    void setNormalizingIndexOffset(int normalizingIndexOffset) {
        this.normalizingIndexOffset = normalizingIndexOffset;
    }

    @Override
    void setIntegerToDoubleValueConversionRatio(double integerToDoubleValueConversionRatio) {
        this.nonConcurrentSetIntegerToDoubleValueConversionRatio(integerToDoubleValueConversionRatio);
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    void resize(long newHighestTrackableValue) {
        int oldNormalizedZeroIndex = this.normalizeIndex(0, this.normalizingIndexOffset, this.countsArrayLength);
        this.establishSize(newHighestTrackableValue);
        int countsDelta = this.countsArrayLength - this.counts.length;
        this.counts = Arrays.copyOf(this.counts, this.countsArrayLength);
        if (oldNormalizedZeroIndex != 0) {
            int newNormalizedZeroIndex = oldNormalizedZeroIndex + countsDelta;
            int lengthToCopy = this.countsArrayLength - countsDelta - oldNormalizedZeroIndex;
            System.arraycopy(this.counts, oldNormalizedZeroIndex, this.counts, newNormalizedZeroIndex, lengthToCopy);
            Arrays.fill(this.counts, oldNormalizedZeroIndex, newNormalizedZeroIndex, 0L);
        }
    }

    public Histogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits, true);
    }

    Histogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits, boolean allocateCountsArray) {
        super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        if (allocateCountsArray) {
            this.counts = new long[this.countsArrayLength];
        }
        this.wordSizeInBytes = 8;
    }

    public static Histogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return Histogram.decodeFromByteBuffer(buffer, Histogram.class, minBarForHighestTrackableValue);
    }
}

