/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.glowroot.agent.shaded.io.netty.util.Constant;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;
import org.glowroot.agent.shaded.io.netty.util.internal.PlatformDependent;

public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = PlatformDependent.newConcurrentHashMap();
    private final AtomicInteger nextId = new AtomicInteger(1);

    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        return this.valueOf(ObjectUtil.checkNotNull(firstNameComponent, "firstNameComponent").getName() + '#' + ObjectUtil.checkNotNull(secondNameComponent, "secondNameComponent"));
    }

    public T valueOf(String name) {
        return this.getOrCreate(ObjectUtil.checkNonEmpty(name, "name"));
    }

    private T getOrCreate(String name) {
        T tempConstant;
        Constant constant = (Constant)this.constants.get(name);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(name, tempConstant = this.newConstant(this.nextId(), name))) == null) {
            return tempConstant;
        }
        return (T)constant;
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

