/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.resolver;

import org.glowroot.agent.shaded.io.netty.resolver.NameResolver;
import org.glowroot.agent.shaded.io.netty.util.concurrent.EventExecutor;
import org.glowroot.agent.shaded.io.netty.util.concurrent.Future;
import org.glowroot.agent.shaded.io.netty.util.concurrent.Promise;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;

public abstract class SimpleNameResolver<T>
implements NameResolver<T> {
    private final EventExecutor executor;

    protected SimpleNameResolver(EventExecutor executor) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public final Future<T> resolve(String inetHost) {
        Promise promise = this.executor().newPromise();
        return this.resolve(inetHost, promise);
    }

    public Future<T> resolve(String inetHost, Promise<T> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        try {
            this.doResolve(inetHost, promise);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure(e);
        }
    }

    protected abstract void doResolve(String var1, Promise<T> var2) throws Exception;

    @Override
    public void close() {
    }
}

