/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.codec.http2;

import org.glowroot.agent.shaded.io.netty.channel.ChannelDuplexHandler;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandlerContext;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2FrameCodec;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2FrameStreamVisitor;

public abstract class Http2ChannelDuplexHandler
extends ChannelDuplexHandler {
    private volatile Http2FrameCodec frameCodec;

    @Override
    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.frameCodec = Http2ChannelDuplexHandler.requireHttp2FrameCodec(ctx);
        this.handlerAdded0(ctx);
    }

    protected void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            this.handlerRemoved0(ctx);
        }
        finally {
            this.frameCodec = null;
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
    }

    protected final void forEachActiveStream(Http2FrameStreamVisitor streamVisitor) throws Http2Exception {
        this.frameCodec.forEachActiveStream(streamVisitor);
    }

    private static Http2FrameCodec requireHttp2FrameCodec(ChannelHandlerContext ctx) {
        ChannelHandlerContext frameCodecCtx = ctx.pipeline().context(Http2FrameCodec.class);
        if (frameCodecCtx == null) {
            throw new IllegalArgumentException(Http2FrameCodec.class.getSimpleName() + " was not found in the channel pipeline.");
        }
        return (Http2FrameCodec)frameCodecCtx.handler();
    }
}

