/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.codec.http.cookie;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.cookie.Cookie;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.cookie.CookieDecoder;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;

public final class ServerCookieDecoder
extends CookieDecoder {
    public static final ServerCookieDecoder STRICT = new ServerCookieDecoder(true);
    public static final ServerCookieDecoder LAX = new ServerCookieDecoder(false);

    private ServerCookieDecoder(boolean strict) {
        super(strict);
    }

    public Set<Cookie> decode(String header) {
        TreeSet<Cookie> cookies = new TreeSet<Cookie>();
        this.decode(cookies, header);
        return cookies;
    }

    private void decode(Collection<? super Cookie> cookies, String header) {
        int headerLen = ObjectUtil.checkNotNull(header, "header").length();
        if (headerLen == 0) {
            return;
        }
        int i = 0;
        boolean rfc2965Style = false;
        if (header.regionMatches(true, 0, "$Version", 0, "$Version".length())) {
            i = header.indexOf(59) + 1;
            rfc2965Style = true;
        }
        while (i != headerLen) {
            DefaultCookie cookie;
            int valueBegin;
            int valueEnd;
            int nameEnd;
            int nameBegin;
            block9: {
                char c = header.charAt(i);
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ',' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                do {
                    char curChar;
                    if ((curChar = header.charAt(i)) == ';') {
                        nameEnd = i;
                        valueEnd = -1;
                        valueBegin = -1;
                    } else {
                        if (curChar != '=') continue;
                        nameEnd = i++;
                        if (i == headerLen) {
                            valueEnd = 0;
                            valueBegin = 0;
                        } else {
                            valueBegin = i;
                            int semiPos = header.indexOf(59, i);
                            i = semiPos > 0 ? semiPos : headerLen;
                            valueEnd = i;
                        }
                    }
                    break block9;
                } while (++i != headerLen);
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
            }
            if (rfc2965Style && (header.regionMatches(nameBegin, "$Path", 0, "$Path".length()) || header.regionMatches(nameBegin, "$Domain", 0, "$Domain".length()) || header.regionMatches(nameBegin, "$Port", 0, "$Port".length())) || (cookie = this.initCookie(header, nameBegin, nameEnd, valueBegin, valueEnd)) == null) continue;
            cookies.add(cookie);
        }
    }
}

