/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.ChannelCredentials;
import org.glowroot.agent.shaded.io.grpc.ManagedChannelProvider;
import org.glowroot.agent.shaded.io.grpc.internal.SharedResourcePool;
import org.glowroot.agent.shaded.io.grpc.netty.NettyChannelBuilder;
import org.glowroot.agent.shaded.io.grpc.netty.NettyChannelProvider;
import org.glowroot.agent.shaded.io.grpc.netty.Utils;
import org.glowroot.agent.shaded.io.netty.channel.unix.DomainSocketAddress;

public final class UdsNettyChannelProvider
extends ManagedChannelProvider {
    @Override
    public boolean isAvailable() {
        return Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE != null;
    }

    @Override
    public int priority() {
        return 3;
    }

    @Override
    public ManagedChannelProvider.NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        Preconditions.checkState(this.isAvailable());
        ManagedChannelProvider.NewChannelBuilderResult result = new NettyChannelProvider().newChannelBuilder(target, creds);
        if (result.getChannelBuilder() != null) {
            ((NettyChannelBuilder)result.getChannelBuilder()).eventLoopGroupPool(SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP)).channelType(Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE, DomainSocketAddress.class);
        }
        return result;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

