/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Throwables;

public final class LogExceptionRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(LogExceptionRunnable.class.getName());
    private final Runnable task;

    public LogExceptionRunnable(Runnable task) {
        this.task = Preconditions.checkNotNull(task, "task");
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Exception while executing runnable " + this.task, t);
            Throwables.throwIfUnchecked(t);
            throw new AssertionError((Object)t);
        }
    }

    public String toString() {
        return "LogExceptionRunnable(" + this.task + ")";
    }
}

