/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Map;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonSetter;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.cfg.ConfigOverride;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.introspect.VisibilityChecker;

public class ConfigOverrides
implements Serializable {
    protected Map<Class<?>, Object> _overrides;
    protected JsonInclude.Value _defaultInclusion;
    protected JsonSetter.Value _defaultSetterInfo;
    protected VisibilityChecker<?> _visibilityChecker;
    protected Boolean _defaultMergeable;
    protected Boolean _defaultLeniency;

    public ConfigOverrides() {
        this(null, JsonInclude.Value.empty(), JsonSetter.Value.empty(), VisibilityChecker.Std.defaultInstance(), null, null);
    }

    protected ConfigOverrides(Map<Class<?>, Object> overrides, JsonInclude.Value defIncl, JsonSetter.Value defSetter, VisibilityChecker<?> defVisibility, Boolean defMergeable, Boolean defLeniency) {
        this._overrides = overrides;
        this._defaultInclusion = defIncl;
        this._defaultSetterInfo = defSetter;
        this._visibilityChecker = defVisibility;
        this._defaultMergeable = defMergeable;
        this._defaultLeniency = defLeniency;
    }

    public ConfigOverride findOverride(Class<?> type) {
        if (this._overrides == null) {
            return null;
        }
        return (ConfigOverride)this._overrides.get(type);
    }

    public JsonFormat.Value findFormatDefaults(Class<?> type) {
        JsonFormat.Value format;
        ConfigOverride override;
        if (this._overrides != null && (override = (ConfigOverride)this._overrides.get(type)) != null && (format = override.getFormat()) != null) {
            if (!format.hasLenient()) {
                return format.withLenient(this._defaultLeniency);
            }
            return format;
        }
        if (this._defaultLeniency == null) {
            return JsonFormat.Value.empty();
        }
        return JsonFormat.Value.forLeniency(this._defaultLeniency);
    }

    public JsonInclude.Value getDefaultInclusion() {
        return this._defaultInclusion;
    }

    public JsonSetter.Value getDefaultSetterInfo() {
        return this._defaultSetterInfo;
    }

    public Boolean getDefaultMergeable() {
        return this._defaultMergeable;
    }

    public VisibilityChecker<?> getDefaultVisibility() {
        return this._visibilityChecker;
    }

    public void setDefaultInclusion(JsonInclude.Value v) {
        this._defaultInclusion = v;
    }
}

