/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.core.io.doubleparser;

class FastDoubleSwar {
    protected static boolean isDigit(char c) {
        return (char)(c - 48) < '\n';
    }

    public static boolean isEightDigits(CharSequence a, int offset) {
        boolean success = true;
        for (int i = 0; i < 8; ++i) {
            char ch = a.charAt(i + offset);
            success &= FastDoubleSwar.isDigit(ch);
        }
        return success;
    }

    public static boolean isEightZeroes(CharSequence a, int offset) {
        boolean success = true;
        for (int i = 0; i < 8; ++i) {
            success &= '0' == a.charAt(i + offset);
        }
        return success;
    }

    public static int readIntBE(byte[] a, int offset) {
        return (a[offset] & 0xFF) << 24 | (a[offset + 1] & 0xFF) << 16 | (a[offset + 2] & 0xFF) << 8 | a[offset + 3] & 0xFF;
    }

    public static int tryToParseEightDigits(CharSequence str, int offset) {
        long first = (long)str.charAt(offset) | (long)str.charAt(offset + 1) << 16 | (long)str.charAt(offset + 2) << 32 | (long)str.charAt(offset + 3) << 48;
        long second = (long)str.charAt(offset + 4) | (long)str.charAt(offset + 5) << 16 | (long)str.charAt(offset + 6) << 32 | (long)str.charAt(offset + 7) << 48;
        return FastDoubleSwar.tryToParseEightDigitsUtf16(first, second);
    }

    public static int tryToParseEightDigitsUtf16(long first, long second) {
        long fval = first - 0x30003000300030L;
        long fpre = first + 0x46004600460046L | fval;
        long sval = second - 0x30003000300030L;
        long spre = second + 0x46004600460046L | sval;
        if (((fpre | spre) & 0xFF80FF80FF80FF80L) != 0L) {
            return -1;
        }
        return (int)(sval * 281475406208040961L >>> 48) + (int)(fval * 281475406208040961L >>> 48) * 10000;
    }

    public static long tryToParseEightHexDigits(CharSequence str, int offset) {
        long first = (long)str.charAt(offset) << 48 | (long)str.charAt(offset + 1) << 32 | (long)str.charAt(offset + 2) << 16 | (long)str.charAt(offset + 3);
        long second = (long)str.charAt(offset + 4) << 48 | (long)str.charAt(offset + 5) << 32 | (long)str.charAt(offset + 6) << 16 | (long)str.charAt(offset + 7);
        return FastDoubleSwar.tryToParseEightHexDigitsUtf16(first, second);
    }

    public static long tryToParseEightHexDigitsUtf16(long first, long second) {
        if (((first | second) & 0xFF00FF00FF00FF00L) != 0L) {
            return -1L;
        }
        long f = first * 65792L;
        long s = second * 65792L;
        long utf8Bytes = f & 0xFFFF000000000000L | (f & 0xFFFF0000L) << 16 | (s & 0xFFFF000000000000L) >>> 32 | (s & 0xFFFF0000L) >>> 16;
        return FastDoubleSwar.tryToParseEightHexDigitsUtf8(utf8Bytes);
    }

    public static long tryToParseEightHexDigitsUtf8(long chunk) {
        long ge_0 = chunk + 0x5050505050505050L;
        long le_9 = 0x3A3A3A3A3A3A3A3AL + (chunk ^ 0x7F7F7F7F7F7F7F7FL);
        long lowerCaseChunk = chunk | 0x2020202020202020L;
        long ge_a = lowerCaseChunk + 0x1F1F1F1F1F1F1F1FL;
        long le_f = 0x6767676767676767L + (lowerCaseChunk ^ 0x7F7F7F7F7F7F7F7FL);
        if (((ge_0 & le_9 ^ (ge_a &= 0x8080808080808080L) & le_f) & 0x8080808080808080L) != -9187201950435737472L) {
            return -1L;
        }
        long ge_a_mask = (ge_a >>> 7) * 255L;
        long vec = lowerCaseChunk - 0x3030303030303030L;
        long v = vec & (ge_a_mask ^ 0xFFFFFFFFFFFFFFFFL) | vec - (0x2727272727272727L & ge_a_mask);
        long v2 = v | v >>> 4;
        long v3 = v2 & 0xFF00FF00FF00FFL;
        long v4 = v3 | v3 >>> 8;
        long v5 = v4 >>> 16 & 0xFFFF0000L | v4 & 0xFFFFL;
        return v5;
    }

    public static int tryToParseFourDigits(CharSequence str, int offset) {
        long first = (long)str.charAt(offset) | (long)str.charAt(offset + 1) << 16 | (long)str.charAt(offset + 2) << 32 | (long)str.charAt(offset + 3) << 48;
        return FastDoubleSwar.tryToParseFourDigitsUtf16(first);
    }

    public static int tryToParseFourDigitsUtf16(long first) {
        long fval = first - 0x30003000300030L;
        long fpre = first + 0x46004600460046L | fval;
        if ((fpre & 0xFF80FF80FF80FF80L) != 0L) {
            return -1;
        }
        return (int)(fval * 281475406208040961L >>> 48);
    }

    public static int tryToParseUpTo7Digits(CharSequence str, int from, int to) {
        int result = 0;
        boolean success = true;
        while (from < to) {
            char ch = str.charAt(from);
            success &= FastDoubleSwar.isDigit(ch);
            result = 10 * result + ch - 48;
            ++from;
        }
        return success ? result : -1;
    }

    public static void writeIntBE(byte[] a, int offset, int v) {
        a[offset] = (byte)(v >>> 24);
        a[offset + 1] = (byte)(v >>> 16);
        a[offset + 2] = (byte)(v >>> 8);
        a[offset + 3] = (byte)v;
    }

    public static double fma(double a, double b, double c) {
        return a * b + c;
    }
}

