/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.annotation;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.Nulls;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface JsonSetter {
    public String value() default "";

    public Nulls nulls() default Nulls.DEFAULT;

    public Nulls contentNulls() default Nulls.DEFAULT;

    public static class Value
    implements Serializable {
        private final Nulls _nulls;
        private final Nulls _contentNulls;
        protected static final Value EMPTY = new Value(Nulls.DEFAULT, Nulls.DEFAULT);

        protected Value(Nulls nulls, Nulls contentNulls) {
            this._nulls = nulls;
            this._contentNulls = contentNulls;
        }

        public static Value from(JsonSetter src) {
            if (src == null) {
                return EMPTY;
            }
            return Value.construct(src.nulls(), src.contentNulls());
        }

        public static Value construct(Nulls nulls, Nulls contentNulls) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (contentNulls == null) {
                contentNulls = Nulls.DEFAULT;
            }
            if (Value._empty(nulls, contentNulls)) {
                return EMPTY;
            }
            return new Value(nulls, contentNulls);
        }

        public static Value empty() {
            return EMPTY;
        }

        public Nulls getContentNulls() {
            return this._contentNulls;
        }

        public Nulls nonDefaultValueNulls() {
            return this._nulls == Nulls.DEFAULT ? null : this._nulls;
        }

        public Nulls nonDefaultContentNulls() {
            return this._contentNulls == Nulls.DEFAULT ? null : this._contentNulls;
        }

        public String toString() {
            return String.format("JsonSetter.Value(valueNulls=%s,contentNulls=%s)", new Object[]{this._nulls, this._contentNulls});
        }

        public int hashCode() {
            return this._nulls.ordinal() + (this._contentNulls.ordinal() << 2);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                Value other = (Value)o;
                return other._nulls == this._nulls && other._contentNulls == this._contentNulls;
            }
            return false;
        }

        private static boolean _empty(Nulls nulls, Nulls contentNulls) {
            return nulls == Nulls.DEFAULT && contentNulls == Nulls.DEFAULT;
        }
    }
}

