/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.spring;

import java.net.URI;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.util.FastThreadLocal;
import org.glowroot.agent.plugin.api.weaving.BindMethodMeta;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.spring.ControllerMethodMeta;

public class ControllerAspect {
    private static final BooleanProperty useAltTransactionNaming = Agent.getConfigService("spring").getBooleanProperty("useAltTransactionNaming");
    private static final ConcurrentMap<String, String> normalizedPatterns = new ConcurrentHashMap<String, String>();
    private static final FastThreadLocal<URI> webSocketUri = new FastThreadLocal();
    private static final FastThreadLocal<String> webSocketTransactionName = new FastThreadLocal();

    private static String getServletPath(@Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
        if (servletRequestInfo == null) {
            return "";
        }
        if (servletRequestInfo.getPathInfo() == null) {
            return servletRequestInfo.getContextPath();
        }
        return servletRequestInfo.getContextPath() + servletRequestInfo.getServletPath();
    }

    private static String getPattern(RequestMappingInfo mapping) {
        PatternsRequestCondition patternCondition = mapping.glowroot$getPatternsCondition();
        if (patternCondition != null) {
            Set<String> patterns = patternCondition.getPatterns();
            if (patterns == null || patterns.isEmpty()) {
                return null;
            }
            return patterns.iterator().next();
        }
        PathPatternsRequestCondition pathPatternCondition = mapping.glowroot$getPathPatternsCondition();
        if (pathPatternCondition == null) {
            return null;
        }
        Set<String> patterns = pathPatternCondition.getPatternValues();
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        return patterns.iterator().next();
    }

    @Pointcut(classAnnotation="org.springframework.stereotype.Controller", methodAnnotation="org.springframework.messaging.handler.annotation.MessageMapping", methodParameterTypes={".."}, timerName="spring websocket controller")
    public static class MessageMappingAdvice {
        private static final TimerName timerName = Agent.getTimerName(ControllerAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(OptionalThreadContext context, @BindMethodMeta ControllerMethodMeta controllerMethodMeta) {
            String transactionName;
            if (useAltTransactionNaming.value()) {
                transactionName = controllerMethodMeta.getAltTransactionName();
            } else {
                transactionName = (String)webSocketTransactionName.get();
                if (transactionName == null) {
                    transactionName = "<unknown>";
                }
            }
            return context.startTransaction("Web", transactionName, MessageSupplier.create("spring websocket controller: {}.{}()", controllerMethodMeta.getControllerClassName(), controllerMethodMeta.getMethodName()), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Pointcut(className="org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler", methodName="handleMatch", methodParameterTypes={"java.lang.Object", "org.springframework.messaging.handler.HandlerMethod", "java.lang.String", "org.springframework.messaging.Message"})
    public static class WebSocketMappingAdvice {
        @OnBefore
        @Nullable
        public static FastThreadLocal.Holder<String> onBefore(@BindParameter @Nullable Object mapping, @BindParameter @Nullable Object handlerMethod, @BindParameter @Nullable String lookupDestination, @BindParameter @Nullable Object message, @BindReceiver AbstractMethodMessageHandler messageHandler) {
            String destination;
            if (useAltTransactionNaming.value()) {
                return null;
            }
            if (!(mapping instanceof SimpMessageMappingInfo)) {
                return null;
            }
            DestinationPatternsMessageCondition patternCondition = ((SimpMessageMappingInfo)mapping).glowroot$getDestinationConditions();
            if (patternCondition == null) {
                return null;
            }
            Set<String> patterns = patternCondition.getPatterns();
            if (patterns == null || patterns.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            URI uri = (URI)webSocketUri.get();
            if (uri != null) {
                sb.append(uri);
            }
            if (lookupDestination != null && message != null && (destination = messageHandler.glowroot$getDestination(message)) != null) {
                sb.append(destination.substring(0, destination.length() - lookupDestination.length()));
            }
            String pattern = patterns.iterator().next();
            FastThreadLocal.Holder<String> holder = webSocketTransactionName.getHolder();
            if (pattern == null || pattern.isEmpty()) {
                holder.set(sb.toString());
                return holder;
            }
            String normalizedPattern = (String)normalizedPatterns.get(pattern);
            if (normalizedPattern == null) {
                normalizedPattern = pattern.replaceAll("\\{[^}]*\\}", "*");
                normalizedPatterns.put(pattern, normalizedPattern);
            }
            sb.append(normalizedPattern);
            holder.set(sb.toString());
            return holder;
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable FastThreadLocal.Holder<String> holder) {
            if (holder != null) {
                holder.set(null);
            }
        }
    }

    @Pointcut(className="org.springframework.messaging.support.ExecutorSubscribableChannel$*", superTypeRestriction="java.lang.Runnable", methodName="run", methodParameterTypes={})
    public static class SendTaskRunAdvice {
        @OnBefore
        public static FastThreadLocal.Holder<URI> onBefore(@BindReceiver WithWebSocketUriMixin withWebSocketUri) {
            FastThreadLocal.Holder<URI> holder = webSocketUri.getHolder();
            holder.set(withWebSocketUri.glowroot$getWebSocketUri());
            return holder;
        }

        @OnAfter
        public static void onAfter(@BindTraveler FastThreadLocal.Holder<URI> holder) {
            holder.set(null);
        }
    }

    @Pointcut(className="org.springframework.messaging.support.ExecutorSubscribableChannel$*", superTypeRestriction="java.lang.Runnable", methodName="<init>", methodParameterTypes={".."})
    public static class SendTaskInitAdvice {
        @OnReturn
        public static void onReturn(@BindReceiver WithWebSocketUriMixin withWebSocketUri) {
            withWebSocketUri.glowroot$setWebSocketUri((URI)webSocketUri.get());
        }
    }

    @Pointcut(className="org.springframework.web.socket.WebSocketHandler", methodName="handleMessage", methodParameterTypes={"org.springframework.web.socket.WebSocketSession", ".."})
    public static class HandleMessageAdvice {
        @OnBefore
        public static FastThreadLocal.Holder<URI> onBefore(@BindParameter WebSocketSession session) {
            FastThreadLocal.Holder<URI> holder = webSocketUri.getHolder();
            holder.set(session.getUri());
            return holder;
        }

        @OnAfter
        public static void onAfter(@BindTraveler FastThreadLocal.Holder<URI> holder) {
            holder.set(null);
        }
    }

    @Pointcut(classAnnotation="org.springframework.stereotype.Controller|org.springframework.web.bind.annotation.RestController", methodAnnotation="org.springframework.web.bind.annotation.RequestMapping", methodParameterTypes={".."}, timerName="spring controller")
    public static class ControllerAdvice {
        private static final TimerName timerName = Agent.getTimerName(ControllerAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(ThreadContext context, @BindMethodMeta ControllerMethodMeta controllerMethodMeta) {
            if (useAltTransactionNaming.value()) {
                context.setTransactionName(controllerMethodMeta.getAltTransactionName(), -100);
            }
            return context.startTraceEntry(MessageSupplier.create("spring controller: {}.{}()", controllerMethodMeta.getControllerClassName(), controllerMethodMeta.getMethodName()), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Pointcut(className="org.springframework.web.servlet.handler.AbstractUrlHandlerMapping", methodName="exposePathWithinMapping", methodParameterTypes={"java.lang.String", "java.lang.String", "javax.servlet.http.HttpServletRequest|jakarta.servlet.http.HttpServletRequest"})
    public static class UrlHandlerMappingAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter @Nullable String bestMatchingPattern) {
            if (useAltTransactionNaming.value()) {
                return;
            }
            String prefix = ControllerAspect.getServletPath(context.getServletRequestInfo());
            if (bestMatchingPattern == null || bestMatchingPattern.isEmpty()) {
                context.setTransactionName(prefix, -100);
                return;
            }
            String normalizedPattern = (String)normalizedPatterns.get(bestMatchingPattern);
            if (normalizedPattern == null) {
                normalizedPattern = bestMatchingPattern.replaceAll("\\{[^}]*\\}", "*");
                normalizedPatterns.put(bestMatchingPattern, normalizedPattern);
            }
            if (prefix == null || prefix.isEmpty()) {
                context.setTransactionName(normalizedPattern, -100);
            } else {
                context.setTransactionName(prefix + normalizedPattern, -100);
            }
        }
    }

    @Pointcut(className="org.springframework.web.servlet.handler.AbstractHandlerMethodMapping", methodName="handleMatch", methodParameterTypes={"java.lang.Object", "java.lang.String", "javax.servlet.http.HttpServletRequest|jakarta.servlet.http.HttpServletRequest"})
    public static class HandlerMethodMappingAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter @Nullable Object mapping) {
            if (useAltTransactionNaming.value()) {
                return;
            }
            if (!(mapping instanceof RequestMappingInfo)) {
                return;
            }
            String pattern = ControllerAspect.getPattern((RequestMappingInfo)mapping);
            if (pattern == null) {
                return;
            }
            String prefix = ControllerAspect.getServletPath(context.getServletRequestInfo());
            if (pattern.isEmpty()) {
                context.setTransactionName(prefix, -100);
                return;
            }
            String normalizedPattern = (String)normalizedPatterns.get(pattern);
            if (normalizedPattern == null) {
                normalizedPattern = pattern.replaceAll("\\{[^}]*\\}", "*");
                normalizedPatterns.put(pattern, normalizedPattern);
            }
            if (prefix == null || prefix.isEmpty()) {
                context.setTransactionName(normalizedPattern, -100);
            } else {
                context.setTransactionName(prefix + normalizedPattern, -100);
            }
        }
    }

    public static interface WithWebSocketUriMixin {
        @Nullable
        public URI glowroot$getWebSocketUri();

        public void glowroot$setWebSocketUri(@Nullable URI var1);
    }

    @Mixin(value={"org.springframework.messaging.support.ExecutorSubscribableChannel$SendTask", "org.springframework.messaging.support.ExecutorSubscribableChannel$1"})
    public static class WithWebSocketUriImpl
    implements WithWebSocketUriMixin {
        @Nullable
        private transient URI glowroot$webSocketUri;

        @Override
        @Nullable
        public URI glowroot$getWebSocketUri() {
            return this.glowroot$webSocketUri;
        }

        @Override
        public void glowroot$setWebSocketUri(@Nullable URI uri) {
            this.glowroot$webSocketUri = uri;
        }
    }

    @Shim(value={"org.springframework.messaging.handler.DestinationPatternsMessageCondition"})
    public static interface DestinationPatternsMessageCondition {
        @Nullable
        public Set<String> getPatterns();
    }

    @Shim(value={"org.springframework.messaging.simp.SimpMessageMappingInfo"})
    public static interface SimpMessageMappingInfo {
        @Shim(value={"org.springframework.messaging.handler.DestinationPatternsMessageCondition getDestinationConditions()"})
        @Nullable
        public DestinationPatternsMessageCondition glowroot$getDestinationConditions();
    }

    @Shim(value={"org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler"})
    public static interface AbstractMethodMessageHandler {
        @Shim(value={"java.lang.String getDestination(org.springframework.messaging.Message)"})
        @Nullable
        public String glowroot$getDestination(Object var1);
    }

    @Shim(value={"org.springframework.web.socket.WebSocketSession"})
    public static interface WebSocketSession {
        @Nullable
        public URI getUri();
    }

    @Shim(value={"org.springframework.web.servlet.mvc.condition.PatternsRequestCondition"})
    public static interface PatternsRequestCondition {
        @Nullable
        public Set<String> getPatterns();
    }

    @Shim(value={"org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition"})
    public static interface PathPatternsRequestCondition {
        @Nullable
        public Set<String> getPatternValues();
    }

    @Shim(value={"org.springframework.web.servlet.mvc.method.RequestMappingInfo"})
    public static interface RequestMappingInfo {
        @Shim(value={"org.springframework.web.servlet.mvc.condition.PatternsRequestCondition getPatternsCondition()"})
        @Nullable
        public PatternsRequestCondition glowroot$getPatternsCondition();

        @Shim(value={"org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition getPathPatternsCondition()"})
        @Nullable
        public PathPatternsRequestCondition glowroot$getPathPatternsCondition();
    }
}

