/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.servlet.bclglowrootbcl;

import java.lang.reflect.Method;
import org.glowroot.agent.plugin.api.ClassInfo;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.Reflection;

public class ResponseInvoker {
    @Nullable
    private final Method getContentTypeMethod;
    @Nullable
    private final Method getHeaderMethod;
    @Nullable
    private final Method getStatusMethod;

    public ResponseInvoker(ClassInfo classInfo) {
        Class<?> servletResponseClass = Reflection.getClassWithWarnIfNotFound("javax.servlet.ServletResponse", classInfo.getLoader());
        this.getContentTypeMethod = Reflection.getMethod(servletResponseClass, "getContentType", new Class[0]);
        Class<?> httpServletResponseClass = Reflection.getClassWithWarnIfNotFound("javax.servlet.http.HttpServletResponse", classInfo.getLoader());
        this.getHeaderMethod = Reflection.getMethod(httpServletResponseClass, "getHeader", String.class);
        this.getStatusMethod = Reflection.getMethod(httpServletResponseClass, "getStatus", new Class[0]);
    }

    public boolean hasGetContentTypeMethod() {
        return this.getContentTypeMethod != null;
    }

    public String getContentType(Object response) {
        return Reflection.invokeWithDefault(this.getContentTypeMethod, response, "", new Object[0]);
    }

    public boolean hasGetHeaderMethod() {
        return this.getHeaderMethod != null;
    }

    public String getHeader(Object response, String name) {
        return Reflection.invokeWithDefault(this.getHeaderMethod, response, "", name);
    }

    public boolean hasGetStatusMethod() {
        return this.getStatusMethod != null;
    }

    public int getStatus(Object response) {
        return Reflection.invokeWithDefault(this.getStatusMethod, response, -1, new Object[0]);
    }
}

