/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.servlet;

import java.util.List;
import java.util.Map;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.Beans;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.servlet.HttpSessions;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.ServletMessageSupplier;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.ServletPluginProperties;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.Strings;

public class SessionAspect {

    @Pointcut(className="javax.servlet.http.HttpSession", methodName="removeAttribute", methodParameterTypes={"java.lang.String"}, nestingGroup="servlet-inner-call")
    public static class RemoveAttributeAdvice {
        @OnAfter
        public static void onAfter(ThreadContext context, @BindParameter @Nullable String name) {
            SetAttributeAdvice.onAfter(context, name, null);
        }
    }

    @Pointcut(className="javax.servlet.http.HttpSession", methodName="setAttribute|putValue", methodParameterTypes={"java.lang.String", "java.lang.Object"}, nestingGroup="servlet-inner-call")
    public static class SetAttributeAdvice {
        @OnAfter
        public static void onAfter(ThreadContext context, @BindParameter @Nullable String name, @BindParameter @Nullable Object value) {
            if (name == null) {
                return;
            }
            ServletMessageSupplier messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo();
            if (messageSupplier != null) {
                SetAttributeAdvice.updateUserIfApplicable(context, name, value);
                SetAttributeAdvice.updateSessionAttributesIfApplicable(messageSupplier, name, value);
            }
        }

        private static void updateUserIfApplicable(ThreadContext context, String attributeName, @Nullable Object attributeValue) {
            if (attributeValue == null) {
                return;
            }
            ServletPluginProperties.SessionAttributePath userAttributePath = ServletPluginProperties.userAttributePath();
            if (userAttributePath == null) {
                return;
            }
            if (!userAttributePath.getAttributeName().equals(attributeName)) {
                return;
            }
            List<String> nestedPath = userAttributePath.getNestedPath();
            if (nestedPath.isEmpty()) {
                context.setTransactionUser(attributeValue.toString(), -100);
            } else {
                Object user;
                try {
                    user = Beans.value(attributeValue, nestedPath);
                }
                catch (Exception e) {
                    user = "<could not access: " + e + ">";
                }
                if (user != null) {
                    context.setTransactionUser(user.toString(), -100);
                }
            }
        }

        private static void updateSessionAttributesIfApplicable(ServletMessageSupplier messageSupplier, String attributeName, @Nullable Object attributeValue) {
            if (ServletPluginProperties.captureSessionAttributeNames().contains(attributeName) || ServletPluginProperties.captureSessionAttributeNames().contains("*")) {
                for (ServletPluginProperties.SessionAttributePath attributePath : ServletPluginProperties.captureSessionAttributePaths()) {
                    if (!attributePath.getAttributeName().equals(attributeName) && !attributePath.isAttributeNameWildcard()) continue;
                    if (attributePath.getNestedPath().isEmpty() && !attributePath.isWildcard()) {
                        SetAttributeAdvice.updateSessionAttribute(messageSupplier, attributeName, attributeValue);
                        continue;
                    }
                    SetAttributeAdvice.updateNestedSessionAttributes(messageSupplier, attributePath, attributeValue);
                }
            }
        }

        private static void updateSessionAttribute(ServletMessageSupplier messageSupplier, String attributeName, @Nullable Object attributeValue) {
            if (attributeValue == null) {
                messageSupplier.putSessionAttributeChangedValue(attributeName, null);
            } else {
                messageSupplier.putSessionAttributeChangedValue(attributeName, Strings.nullToEmpty(attributeValue.toString()));
            }
        }

        private static void updateNestedSessionAttributes(ServletMessageSupplier messageSupplier, ServletPluginProperties.SessionAttributePath attributePath, @Nullable Object attributeValue) {
            String fullPath = attributePath.getFullPath();
            if (attributePath.isWildcard()) {
                Object val = HttpSessions.getSessionAttribute(attributeValue, attributePath);
                if (val == null) {
                    messageSupplier.putSessionAttributeChangedValue(fullPath, null);
                } else if (val instanceof Map) {
                    for (Map.Entry entry : ((Map)val).entrySet()) {
                        Object v = entry.getValue();
                        messageSupplier.putSessionAttributeChangedValue(fullPath + "." + entry.getKey(), v == null ? null : Strings.nullToEmpty(v.toString()));
                    }
                } else {
                    for (Map.Entry<String, String> entry : Beans.propertiesAsText(val).entrySet()) {
                        messageSupplier.putSessionAttributeChangedValue(fullPath + "." + entry.getKey(), entry.getValue());
                    }
                }
            } else if (attributeValue == null) {
                messageSupplier.putSessionAttributeChangedValue(fullPath, null);
            } else {
                Object val = HttpSessions.getSessionAttribute(attributeValue, attributePath);
                messageSupplier.putSessionAttributeChangedValue(fullPath, val == null ? null : Strings.nullToEmpty(val.toString()));
            }
        }
    }
}

