/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.Beans;
import org.glowroot.agent.plugin.api.util.ImmutableMap;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.ServletPluginProperties;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.Strings;

public class HttpSessions {
    private HttpSessions() {
    }

    public static Map<String, String> getSessionAttributes(HttpSession session) {
        List<ServletPluginProperties.SessionAttributePath> attributePaths = ServletPluginProperties.captureSessionAttributePaths();
        if (attributePaths.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> captureMap = new HashMap<String, String>();
        for (ServletPluginProperties.SessionAttributePath attributePath : attributePaths) {
            if (attributePath.isAttributeNameWildcard()) {
                HttpSessions.captureAllSessionAttributes(session, captureMap);
                continue;
            }
            if (attributePath.isWildcard()) {
                HttpSessions.captureWildcardPath(session, captureMap, attributePath);
                continue;
            }
            HttpSessions.captureNonWildcardPath(session, captureMap, attributePath);
        }
        return ImmutableMap.copyOf(captureMap);
    }

    @Nullable
    public static Object getSessionAttribute(HttpSession session, ServletPluginProperties.SessionAttributePath attributePath) {
        if (attributePath.isSessionId()) {
            return session.getId();
        }
        Object attributeValue = session.getAttribute(attributePath.getAttributeName());
        return HttpSessions.getSessionAttribute(attributeValue, attributePath);
    }

    @Nullable
    public static Object getSessionAttribute(@Nullable Object attributeValue, ServletPluginProperties.SessionAttributePath attributePath) {
        List<String> nestedPath = attributePath.getNestedPath();
        if (nestedPath.isEmpty()) {
            return attributeValue;
        }
        try {
            return Beans.value(attributeValue, nestedPath);
        }
        catch (Exception e) {
            return "<error evaluating: " + e + ">";
        }
    }

    private static void captureAllSessionAttributes(HttpSession session, Map<String, String> captureMap) {
        Enumeration e = session.getAttributeNames();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            String value;
            String attributeName = (String)e.nextElement();
            if (attributeName == null) continue;
            if (attributeName.equals("::id")) {
                captureMap.put(attributeName, Strings.nullToEmpty(session.getId()));
                continue;
            }
            Object valueObj = session.getAttribute(attributeName);
            if (valueObj == null) continue;
            try {
                value = Strings.nullToEmpty(valueObj.toString());
            }
            catch (Exception f) {
                value = "<error evaluating: " + f + ">";
            }
            captureMap.put(attributeName, value);
        }
    }

    private static void captureWildcardPath(HttpSession session, Map<String, String> captureMap, ServletPluginProperties.SessionAttributePath attributePath) {
        block3: {
            Object value;
            block2: {
                value = HttpSessions.getSessionAttribute(session, attributePath);
                if (!(value instanceof Map)) break block2;
                String fullPath = attributePath.getFullPath();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object val = entry.getValue();
                    captureMap.put(fullPath + "." + entry.getKey(), val == null ? "" : Strings.nullToEmpty(val.toString()));
                }
                break block3;
            }
            if (value == null) break block3;
            String fullPath = attributePath.getFullPath();
            for (Map.Entry<String, String> entry : Beans.propertiesAsText(value).entrySet()) {
                captureMap.put(fullPath + "." + entry.getKey(), entry.getValue());
            }
        }
    }

    private static void captureNonWildcardPath(HttpSession session, Map<String, String> captureMap, ServletPluginProperties.SessionAttributePath attributePath) {
        Object value = HttpSessions.getSessionAttribute(session, attributePath);
        if (value != null) {
            captureMap.put(attributePath.getFullPath(), Strings.nullToEmpty(value.toString()));
        }
    }
}

