/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.ImmutableList;
import org.glowroot.agent.plugin.api.util.ImmutableMap;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.RequestHostAndPortDetail;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.RequestInvoker;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.ServletPluginProperties;
import org.glowroot.agent.plugin.servlet.bclglowrootbcl.Strings;

public class DetailCapture {
    private DetailCapture() {
    }

    public static Map<String, Object> captureRequestParameters(Map<String, ?> requestParameters) {
        List<Pattern> capturePatterns = ServletPluginProperties.captureRequestParameters();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : requestParameters.entrySet()) {
            Object value;
            String keyLowerCase;
            String name = entry.getKey();
            if (name == null || !DetailCapture.matchesOneOf(keyLowerCase = name.toLowerCase(Locale.ENGLISH), capturePatterns) || !((value = entry.getValue()) instanceof String[])) continue;
            DetailCapture.set(map, name, (String[])value);
        }
        return ImmutableMap.copyOf(map);
    }

    public static Map<String, Object> captureRequestParameters(HttpServletRequest request) {
        Enumeration e = request.getParameterNames();
        if (e == null) {
            return Collections.emptyMap();
        }
        List<Pattern> capturePatterns = ServletPluginProperties.captureRequestParameters();
        List<Pattern> maskPatterns = ServletPluginProperties.maskRequestParameters();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (e.hasMoreElements()) {
            String name;
            String keyLowerCase;
            Object nameObj = e.nextElement();
            if (nameObj == null || !(nameObj instanceof String) || !DetailCapture.matchesOneOf(keyLowerCase = (name = (String)nameObj).toLowerCase(Locale.ENGLISH), capturePatterns)) continue;
            if (DetailCapture.matchesOneOf(keyLowerCase, maskPatterns)) {
                map.put(name, "****");
                continue;
            }
            String[] values = request.getParameterValues(name);
            if (values == null) continue;
            DetailCapture.set(map, name, values);
        }
        return ImmutableMap.copyOf(map);
    }

    private static void set(Map<String, Object> map, String name, String[] values) {
        if (values.length == 1) {
            String value = values[0];
            if (value != null) {
                map.put(name, value);
            }
        } else {
            ArrayList list = new ArrayList(values.length);
            Collections.addAll(list, values);
            map.put(name, list);
        }
    }

    public static Map<String, Object> captureRequestHeaders(HttpServletRequest request) {
        List<Pattern> capturePatterns = ServletPluginProperties.captureRequestHeaders();
        if (capturePatterns.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames == null) {
            return Collections.emptyMap();
        }
        Enumeration e = headerNames;
        while (e.hasMoreElements()) {
            Enumeration values;
            String keyLowerCase;
            String name = (String)e.nextElement();
            if (name == null || !DetailCapture.matchesOneOf(keyLowerCase = name.toLowerCase(Locale.ENGLISH), capturePatterns) || (values = request.getHeaders(name)) == null) continue;
            DetailCapture.captureRequestHeader(name, values, requestHeaders);
        }
        return ImmutableMap.copyOf(requestHeaders);
    }

    @Nullable
    public static RequestHostAndPortDetail captureRequestHostAndPortDetail(HttpServletRequest request, RequestInvoker requestInvoker) {
        if (ServletPluginProperties.captureSomeRequestHostAndPortDetail()) {
            RequestHostAndPortDetail requestHostAndPortDetail = new RequestHostAndPortDetail();
            if (ServletPluginProperties.captureRequestRemoteAddress()) {
                requestHostAndPortDetail.remoteAddress = request.getRemoteAddr();
            }
            if (ServletPluginProperties.captureRequestRemoteHostname()) {
                requestHostAndPortDetail.remoteHostname = request.getRemoteHost();
            }
            if (ServletPluginProperties.captureRequestRemotePort()) {
                requestHostAndPortDetail.remotePort = requestInvoker.getRemotePort(request);
            }
            if (ServletPluginProperties.captureRequestLocalAddress()) {
                requestHostAndPortDetail.localAddress = requestInvoker.getLocalAddr(request);
            }
            if (ServletPluginProperties.captureRequestLocalHostname()) {
                requestHostAndPortDetail.localHostname = requestInvoker.getLocalName(request);
            }
            if (ServletPluginProperties.captureRequestLocalPort()) {
                requestHostAndPortDetail.localPort = requestInvoker.getLocalPort(request);
            }
            if (ServletPluginProperties.captureRequestServerHostname()) {
                requestHostAndPortDetail.serverHostname = request.getServerName();
            }
            if (ServletPluginProperties.captureRequestServerPort()) {
                requestHostAndPortDetail.serverPort = request.getServerPort();
            }
            return requestHostAndPortDetail;
        }
        return null;
    }

    public static boolean matchesOneOf(String key, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    private static void captureRequestHeader(String name, Enumeration<String> values, Map<String, Object> requestHeaders) {
        if (!values.hasMoreElements()) {
            requestHeaders.put(name, "");
        } else {
            String value = values.nextElement();
            if (!values.hasMoreElements()) {
                requestHeaders.put(name, Strings.nullToEmpty(value));
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(Strings.nullToEmpty(value));
                while (values.hasMoreElements()) {
                    list.add(Strings.nullToEmpty(values.nextElement()));
                }
                requestHeaders.put(name, ImmutableList.copyOf(list));
            }
        }
    }
}

