/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.servlet;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;

public class ContainerStartup {
    private static final Logger logger = Logger.getLogger(ContainerStartup.class);

    private ContainerStartup() {
    }

    static TraceEntry onBeforeCommon(OptionalThreadContext context, @Nullable String path, TimerName timerName) {
        ContainerStartup.initPlatformMBeanServer();
        String transactionName = path == null || path.isEmpty() ? "Servlet context: /" : "Servlet context: " + path;
        TraceEntry traceEntry = context.startTransaction("Startup", transactionName, MessageSupplier.create(transactionName), timerName);
        context.setTransactionSlowThreshold(0L, TimeUnit.MILLISECONDS, -100);
        return traceEntry;
    }

    static void initPlatformMBeanServer() {
        try {
            ManagementFactory.getPlatformMBeanServer();
        }
        catch (Throwable t) {
            logger.error("could not create platform mbean server: {}", (Object)t.getMessage(), (Object)t);
        }
    }
}

