/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.logger;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.logger.LoggerNameAbbreviator;

class LoggerPlugin {
    private static final ConfigService configService = Agent.getConfigService("logger");
    private static final BooleanProperty traceErrorOnWarningWithThrowable = configService.getBooleanProperty("traceErrorOnWarningWithThrowable");
    private static final BooleanProperty traceErrorOnWarningWithoutThrowable = configService.getBooleanProperty("traceErrorOnWarningWithoutThrowable");
    private static final BooleanProperty traceErrorOnErrorWithThrowable = configService.getBooleanProperty("traceErrorOnErrorWithThrowable");
    private static final BooleanProperty traceErrorOnErrorWithoutThrowable = configService.getBooleanProperty("traceErrorOnErrorWithoutThrowable");
    private static final LoggerNameAbbreviator loggerNameAbbreviator = new LoggerNameAbbreviator(36);

    private LoggerPlugin() {
    }

    static boolean markTraceAsError(boolean isErrorOrHigher, boolean isWarnOrHigher, boolean throwable) {
        if (isErrorOrHigher) {
            return throwable ? traceErrorOnErrorWithThrowable.value() : traceErrorOnErrorWithoutThrowable.value();
        }
        if (isWarnOrHigher) {
            return throwable ? traceErrorOnWarningWithThrowable.value() : traceErrorOnWarningWithoutThrowable.value();
        }
        return false;
    }

    static String getAbbreviatedLoggerName(@Nullable String loggerName) {
        if (loggerName == null) {
            return "null";
        }
        return loggerNameAbbreviator.abbreviate(loggerName);
    }
}

