/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.util.ImmutableMap;

public class JdbcPluginProperties {
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static int stackTraceThresholdMillis;
    private static volatile Map<String, Set<Integer>> displayBinaryParameterAsHex;

    private JdbcPluginProperties() {
    }

    public static void setDisplayBinaryParameterAsHex(String sql, int parameterIndex) {
        HashMap<String, Set<Integer>> mutableMap = new HashMap<String, Set<Integer>>(displayBinaryParameterAsHex);
        HashSet<Integer> set = (HashSet<Integer>)mutableMap.get(sql);
        set = set == null ? new HashSet<Integer>() : new HashSet(set);
        set.add(parameterIndex);
        mutableMap.put(sql, set);
        displayBinaryParameterAsHex = ImmutableMap.copyOf(mutableMap);
    }

    static int stackTraceThresholdMillis() {
        return stackTraceThresholdMillis;
    }

    static boolean displayBinaryParameterAsHex(String sql, int parameterIndex) {
        Set<Integer> set = displayBinaryParameterAsHex.get(sql);
        return set != null && set.contains(parameterIndex);
    }

    static {
        displayBinaryParameterAsHex = Collections.emptyMap();
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                Double value = configService.getDoubleProperty("stackTraceThresholdMillis").value();
                stackTraceThresholdMillis = value == null ? Integer.MAX_VALUE : value.intValue();
            }
        });
    }
}

