/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jaxrs;

import java.util.List;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.weaving.BindMethodMeta;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.jaxrs.ResourceMethodMeta;

public class ResourceAspect {
    private static final BooleanProperty useAltTransactionNaming = Agent.getConfigService("jaxrs").getBooleanProperty("useAltTransactionNaming");

    @Pointcut(methodAnnotation="javax.ws.rs.Path|jakarta.ws.rs.Path|javax.ws.rs.DELETE|jakarta.ws.rs.DELETE|javax.ws.rs.GET|jakarta.ws.rs.GET|javax.ws.rs.HEAD|jakarta.ws.rs.HEAD|javax.ws.rs.OPTIONS|jakarta.ws.rs.OPTIONS|javax.ws.rs.POST|jakarta.ws.rs.POST|javax.ws.rs.PUT|jakarta.ws.rs.PUT", methodParameterTypes={".."}, timerName="jaxrs resource", nestingGroup="jaxrs")
    public static class ResourceAdvice {
        private static final TimerName timerName = Agent.getTimerName(ResourceAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(ThreadContext context, @BindMethodMeta ResourceMethodMeta resourceMethodMeta) {
            ThreadContext.ServletRequestInfo servletRequestInfo;
            if (resourceMethodMeta.hasHttpMethodAnnotation()) {
                if (useAltTransactionNaming.value()) {
                    context.setTransactionName(resourceMethodMeta.getAltTransactionName(), -100);
                } else {
                    ThreadContext.ServletRequestInfo servletRequestInfo2 = context.getServletRequestInfo();
                    if (servletRequestInfo2 != null) {
                        List<String> jaxRsParts = servletRequestInfo2.getJaxRsParts();
                        String path = resourceMethodMeta.getPath();
                        if (!jaxRsParts.isEmpty()) {
                            StringBuilder sb = new StringBuilder();
                            for (String jaxRsPart : jaxRsParts) {
                                sb.append(jaxRsPart);
                            }
                            sb.append(path);
                            path = sb.toString();
                        }
                        String transactionName = ResourceAdvice.getTransactionName(path, servletRequestInfo2);
                        context.setTransactionName(transactionName, -100);
                    }
                }
                return context.startTraceEntry(MessageSupplier.create("jaxrs resource: {}.{}()", resourceMethodMeta.getResourceClassName(), resourceMethodMeta.getMethodName()), timerName);
            }
            if (!useAltTransactionNaming.value() && (servletRequestInfo = context.getServletRequestInfo()) != null) {
                servletRequestInfo.addJaxRsPart(resourceMethodMeta.getPath());
            }
            return null;
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.endWithError(t);
            }
        }

        private static String getTransactionName(String path, @Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
            if (servletRequestInfo == null) {
                return path;
            }
            String method = servletRequestInfo.getMethod();
            String servletPath = ResourceAdvice.getServletPath(servletRequestInfo);
            if (method.isEmpty()) {
                return servletPath + path;
            }
            return method + " " + servletPath + path;
        }

        private static String getServletPath(ThreadContext.ServletRequestInfo servletRequestInfo) {
            if (servletRequestInfo.getPathInfo() == null) {
                return servletRequestInfo.getContextPath();
            }
            return servletRequestInfo.getContextPath() + servletRequestInfo.getServletPath();
        }
    }
}

