/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.util.ImmutableList;
import org.glowroot.agent.plugin.api.util.ImmutableSet;
import org.glowroot.agent.plugin.jakartaservlet.DetailCapture;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.Strings;

public class ServletPluginProperties {
    public static final String HTTP_SESSION_ID_ATTR = "::id";
    private static final ConfigService configService = Agent.getConfigService("jakartaservlet");
    private static List<Pattern> captureRequestParameters = Collections.emptyList();
    private static List<Pattern> maskRequestParameters = Collections.emptyList();
    private static List<Pattern> captureRequestHeaders = Collections.emptyList();
    private static boolean someRequestHostAndPortDetail;
    private static boolean captureRequestRemoteAddress;
    private static boolean captureRequestRemoteHostname;
    private static boolean captureRequestRemotePort;
    private static boolean captureRequestLocalAddress;
    private static boolean captureRequestLocalHostname;
    private static boolean captureRequestLocalPort;
    private static boolean captureRequestServerHostname;
    private static boolean captureRequestServerPort;
    private static List<Pattern> captureResponseHeaders;
    private static boolean captureResponseHeadersNonEmpty;
    private static boolean captureContentLengthResponseHeader;
    private static boolean captureContentTypeResponseHeader;
    private static boolean captureContentLanguageResponseHeader;
    @Nullable
    private static SessionAttributePath userAttributePath;
    private static List<SessionAttributePath> captureSessionAttributePaths;
    private static Set<String> captureSessionAttributeNames;
    private static boolean captureSessionAttributeNamesContainsId;
    private static boolean traceErrorOn4xxResponseCode;

    private ServletPluginProperties() {
    }

    public static List<Pattern> captureRequestParameters() {
        return captureRequestParameters;
    }

    public static List<Pattern> maskRequestParameters() {
        return maskRequestParameters;
    }

    public static List<Pattern> captureRequestHeaders() {
        return captureRequestHeaders;
    }

    public static boolean captureSomeRequestHostAndPortDetail() {
        return someRequestHostAndPortDetail;
    }

    public static boolean captureRequestRemoteAddress() {
        return captureRequestRemoteAddress;
    }

    public static boolean captureRequestRemoteHostname() {
        return captureRequestRemoteHostname;
    }

    public static boolean captureRequestRemotePort() {
        return captureRequestRemotePort;
    }

    public static boolean captureRequestLocalAddress() {
        return captureRequestLocalAddress;
    }

    public static boolean captureRequestLocalHostname() {
        return captureRequestLocalHostname;
    }

    public static boolean captureRequestLocalPort() {
        return captureRequestLocalPort;
    }

    public static boolean captureRequestServerHostname() {
        return captureRequestServerHostname;
    }

    public static boolean captureRequestServerPort() {
        return captureRequestServerPort;
    }

    public static List<Pattern> captureResponseHeaders() {
        return captureResponseHeaders;
    }

    public static boolean captureResponseHeadersNonEmpty() {
        return captureResponseHeadersNonEmpty;
    }

    public static boolean captureContentLengthResponseHeader() {
        return captureContentLengthResponseHeader;
    }

    public static boolean captureContentTypeResponseHeader() {
        return captureContentTypeResponseHeader;
    }

    public static boolean captureContentLanguageResponseHeader() {
        return captureContentLanguageResponseHeader;
    }

    @Nullable
    public static SessionAttributePath userAttributePath() {
        return userAttributePath;
    }

    public static boolean sessionUserAttributeIsId() {
        return userAttributePath != null && userAttributePath.isSessionId();
    }

    public static List<SessionAttributePath> captureSessionAttributePaths() {
        return captureSessionAttributePaths;
    }

    public static Set<String> captureSessionAttributeNames() {
        return captureSessionAttributeNames;
    }

    public static boolean captureSessionAttributeNamesContainsId() {
        return captureSessionAttributeNamesContainsId;
    }

    public static boolean traceErrorOn4xxResponseCode() {
        return traceErrorOn4xxResponseCode;
    }

    static {
        captureResponseHeaders = Collections.emptyList();
        captureSessionAttributePaths = Collections.emptyList();
        captureSessionAttributeNames = Collections.emptySet();
        configService.registerConfigListener(new ServletPluginConfigListener());
    }

    private static class ServletPluginConfigListener
    implements ConfigListener {
        private ServletPluginConfigListener() {
        }

        @Override
        public void onChange() {
            ServletPluginConfigListener.recalculateProperties();
        }

        private static void recalculateProperties() {
            captureRequestParameters = ServletPluginConfigListener.buildPatternList("captureRequestParameters");
            maskRequestParameters = ServletPluginConfigListener.buildPatternList("maskRequestParameters");
            captureRequestHeaders = ServletPluginConfigListener.buildPatternList("captureRequestHeaders");
            captureRequestRemoteAddress = configService.getBooleanProperty("captureRequestRemoteAddr").value();
            captureRequestRemoteHostname = configService.getBooleanProperty("captureRequestRemoteHostname").value();
            captureRequestRemotePort = configService.getBooleanProperty("captureRequestRemotePort").value();
            captureRequestLocalAddress = configService.getBooleanProperty("captureRequestLocalAddr").value();
            captureRequestLocalHostname = configService.getBooleanProperty("captureRequestLocalHostname").value();
            captureRequestLocalPort = configService.getBooleanProperty("captureRequestLocalPort").value();
            captureRequestServerHostname = configService.getBooleanProperty("captureRequestServerHostname").value();
            captureRequestServerPort = configService.getBooleanProperty("captureRequestServerPort").value();
            someRequestHostAndPortDetail = captureRequestRemoteAddress || captureRequestRemoteHostname || captureRequestRemotePort || captureRequestLocalAddress || captureRequestLocalHostname || captureRequestLocalPort || captureRequestServerHostname || captureRequestServerPort;
            captureResponseHeaders = ServletPluginConfigListener.buildPatternList("captureResponseHeaders");
            captureResponseHeadersNonEmpty = !captureResponseHeaders.isEmpty();
            captureContentLengthResponseHeader = DetailCapture.matchesOneOf("content-length", captureResponseHeaders);
            captureContentTypeResponseHeader = DetailCapture.matchesOneOf("content-type", captureResponseHeaders);
            captureContentLanguageResponseHeader = DetailCapture.matchesOneOf("content-language", captureResponseHeaders);
            userAttributePath = ServletPluginConfigListener.buildSessionAttributePath(configService.getStringProperty("sessionUserAttribute").value());
            captureSessionAttributePaths = ServletPluginConfigListener.buildSessionAttributePaths(configService.getListProperty("captureSessionAttributes").value());
            captureSessionAttributeNames = ServletPluginConfigListener.buildCaptureSessionAttributeNames();
            captureSessionAttributeNamesContainsId = captureSessionAttributeNames.contains(ServletPluginProperties.HTTP_SESSION_ID_ATTR);
            traceErrorOn4xxResponseCode = configService.getBooleanProperty("traceErrorOn4xxResponseCode").value();
        }

        private static List<Pattern> buildPatternList(String propertyName) {
            List<String> values = configService.getListProperty(propertyName).value();
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String value : values) {
                patterns.add(ServletPluginConfigListener.buildRegexPattern(value.trim().toLowerCase(Locale.ENGLISH)));
            }
            return ImmutableList.copyOf(patterns);
        }

        private static List<SessionAttributePath> buildSessionAttributePaths(List<String> sessionAttributes) {
            ArrayList<SessionAttributePath> attributePaths = new ArrayList<SessionAttributePath>();
            for (String sessionAttribute : sessionAttributes) {
                attributePaths.add(ServletPluginConfigListener.buildSessionAttributePath(sessionAttribute.trim()));
            }
            return ImmutableList.copyOf(attributePaths);
        }

        private static SessionAttributePath buildSessionAttributePath(String sessionAttribute) {
            int index;
            boolean wildcard = sessionAttribute.endsWith(".*");
            String sessionAttr = sessionAttribute;
            if (wildcard) {
                sessionAttr = sessionAttribute.substring(0, sessionAttribute.length() - 2);
            }
            if ((index = sessionAttr.indexOf(46)) == -1) {
                return new SessionAttributePath(sessionAttr, Collections.emptyList(), wildcard, sessionAttr);
            }
            String attributeName = sessionAttr.substring(0, index);
            String remaining = sessionAttr.substring(index + 1);
            List<String> nestedPath = Strings.split(remaining, '.');
            return new SessionAttributePath(attributeName, nestedPath, wildcard, sessionAttr);
        }

        private static Set<String> buildCaptureSessionAttributeNames() {
            HashSet<String> names = new HashSet<String>();
            for (SessionAttributePath sessionAttributePath : captureSessionAttributePaths) {
                names.add(sessionAttributePath.attributeName);
            }
            return ImmutableSet.copyOf(names);
        }

        private static Pattern buildRegexPattern(String wildcardPattern) {
            String regex = "\\Q" + wildcardPattern.replace("*", "\\E.*\\Q") + "\\E";
            regex = regex.replace("\\Q\\E", "");
            return Pattern.compile(regex);
        }
    }

    public static class SessionAttributePath {
        private final String attributeName;
        private final List<String> nestedPath;
        private final boolean wildcard;
        private final String fullPath;

        private SessionAttributePath(String attributeName, List<String> nestedPath, boolean wildcard, String fullPath) {
            this.attributeName = attributeName;
            this.nestedPath = nestedPath;
            this.wildcard = wildcard;
            this.fullPath = fullPath;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public List<String> getNestedPath() {
            return this.nestedPath;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public boolean isAttributeNameWildcard() {
            return this.attributeName.equals("*") && this.nestedPath.isEmpty() && !this.wildcard;
        }

        public boolean isSessionId() {
            return this.attributeName.equals(ServletPluginProperties.HTTP_SESSION_ID_ATTR) && this.nestedPath.isEmpty() && !this.wildcard;
        }
    }
}

