/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.glowroot.agent.plugin.api.Message;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.checker.MonotonicNonNull;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.checker.RequiresNonNull;
import org.glowroot.agent.plugin.api.util.Optional;
import org.glowroot.agent.plugin.jakartaservlet.DetailCapture;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.RequestHostAndPortDetail;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.ResponseHeaderComponent;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.ServletPluginProperties;

public class ServletMessageSupplier
extends MessageSupplier
implements ThreadContext.ServletRequestInfo {
    private static final String MASK_TEXT = "****";
    private final String requestMethod;
    private final String requestContextPath;
    private final String requestServletPath;
    @Nullable
    private final String requestPathInfo;
    private final String requestUri;
    @Nullable
    private final String requestQueryString;
    @MonotonicNonNull
    private volatile Map<String, Object> requestParameters;
    private final Map<String, Object> requestHeaders;
    @Nullable
    private final RequestHostAndPortDetail requestHostAndPortDetail;
    private volatile int responseCode;
    private final ResponseHeaderComponent responseHeaderComponent = new ResponseHeaderComponent();
    private final Map<String, String> sessionAttributeInitialValueMap;
    @MonotonicNonNull
    private volatile ConcurrentMap<String, Optional<String>> sessionAttributeUpdatedValueMap;
    @Nullable
    private List<String> jaxRsParts;

    public ServletMessageSupplier(String requestMethod, String requestContextPath, String requestServletPath, @Nullable String requestPathInfo, String requestUri, @Nullable String requestQueryString, Map<String, Object> requestHeaders, @Nullable RequestHostAndPortDetail requestHostAndPortDetail, Map<String, String> sessionAttributeMap) {
        this.requestMethod = requestMethod;
        this.requestContextPath = requestContextPath;
        this.requestServletPath = requestServletPath;
        this.requestPathInfo = requestPathInfo;
        this.requestUri = requestUri;
        this.requestQueryString = requestQueryString;
        this.requestHeaders = requestHeaders;
        this.requestHostAndPortDetail = requestHostAndPortDetail;
        this.sessionAttributeInitialValueMap = sessionAttributeMap;
    }

    @Override
    public Message get() {
        Map<String, Object> responseHeaderStrings;
        Map<String, Object> maskedRequestParameters;
        List<Pattern> maskPatterns = ServletPluginProperties.maskRequestParameters();
        LinkedHashMap<String, Object> detail = new LinkedHashMap<String, Object>();
        detail.put("Request http method", this.requestMethod);
        String maskedRequestQueryString = ServletMessageSupplier.maskRequestQueryString(this.requestQueryString, maskPatterns);
        if (maskedRequestQueryString != null) {
            detail.put("Request query string", maskedRequestQueryString);
        }
        if ((maskedRequestParameters = ServletMessageSupplier.maskRequestParameters(this.requestParameters, maskPatterns)) != null && !maskedRequestParameters.isEmpty()) {
            detail.put("Request parameters", maskedRequestParameters);
        }
        if (!this.requestHeaders.isEmpty()) {
            detail.put("Request headers", this.requestHeaders);
        }
        if (this.requestHostAndPortDetail != null) {
            if (this.requestHostAndPortDetail.remoteAddress != null) {
                detail.put("Request remote address", this.requestHostAndPortDetail.remoteAddress);
            }
            if (this.requestHostAndPortDetail.remoteHostname != null) {
                detail.put("Request remote hostname", this.requestHostAndPortDetail.remoteHostname);
            }
            if (this.requestHostAndPortDetail.remotePort != -2) {
                detail.put("Request remote port", this.requestHostAndPortDetail.remotePort);
            }
            if (this.requestHostAndPortDetail.localAddress != null) {
                detail.put("Request local address", this.requestHostAndPortDetail.localAddress);
            }
            if (this.requestHostAndPortDetail.localHostname != null) {
                detail.put("Request local hostname", this.requestHostAndPortDetail.localHostname);
            }
            if (this.requestHostAndPortDetail.localPort != -2) {
                detail.put("Request local port", this.requestHostAndPortDetail.localPort);
            }
            if (this.requestHostAndPortDetail.serverHostname != null) {
                detail.put("Request server hostname", this.requestHostAndPortDetail.serverHostname);
            }
            if (this.requestHostAndPortDetail.serverPort != -2) {
                detail.put("Request server port", this.requestHostAndPortDetail.serverPort);
            }
        }
        if (this.responseCode != 0) {
            detail.put("Response code", this.responseCode);
        }
        if (!(responseHeaderStrings = this.responseHeaderComponent.getMapOfStrings()).isEmpty()) {
            detail.put("Response headers", responseHeaderStrings);
        }
        this.addSessionAttributeDetail(detail);
        return Message.create(this.requestUri, detail);
    }

    @Override
    public String getMethod() {
        return this.requestMethod;
    }

    @Override
    public String getContextPath() {
        return this.requestContextPath;
    }

    @Override
    public String getServletPath() {
        return this.requestServletPath;
    }

    @Override
    @Nullable
    public String getPathInfo() {
        return this.requestPathInfo;
    }

    @Override
    public String getUri() {
        return this.requestUri;
    }

    @Override
    public void addJaxRsPart(String part) {
        if (this.jaxRsParts == null) {
            this.jaxRsParts = new ArrayList<String>();
        }
        this.jaxRsParts.add(part);
    }

    @Override
    public List<String> getJaxRsParts() {
        return this.jaxRsParts == null ? Collections.emptyList() : this.jaxRsParts;
    }

    public boolean isRequestParametersCaptured() {
        return this.requestParameters != null;
    }

    public void setCaptureRequestParameters(Map<String, Object> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setResponseHeader(String name, String value) {
        this.responseHeaderComponent.setHeader(name, value);
    }

    public void setResponseDateHeader(String name, long date) {
        this.responseHeaderComponent.setHeader(name, date);
    }

    public void setResponseIntHeader(String name, int value) {
        this.responseHeaderComponent.setHeader(name, value);
    }

    public void setResponseLongHeader(String name, long value) {
        this.responseHeaderComponent.setHeader(name, value);
    }

    public void addResponseHeader(String name, String value) {
        this.responseHeaderComponent.addHeader(name, value);
    }

    public void addResponseDateHeader(String name, long date) {
        this.responseHeaderComponent.addHeader(name, date);
    }

    public void addResponseIntHeader(String name, int value) {
        this.responseHeaderComponent.addHeader(name, value);
    }

    public void putSessionAttributeChangedValue(String attributeName, @Nullable String attributeValue) {
        if (this.sessionAttributeUpdatedValueMap == null) {
            this.sessionAttributeUpdatedValueMap = new ConcurrentHashMap<String, Optional<String>>();
        }
        this.sessionAttributeUpdatedValueMap.put(attributeName, Optional.fromNullable(attributeValue));
    }

    private void addSessionAttributeDetail(Map<String, Object> detail) {
        if (!this.sessionAttributeInitialValueMap.isEmpty()) {
            if (this.sessionAttributeUpdatedValueMap == null) {
                detail.put("Session attributes", this.sessionAttributeInitialValueMap);
            } else {
                this.addMidRequestSessionAttributeDetail(detail);
            }
        } else if (this.sessionAttributeUpdatedValueMap != null) {
            detail.put("Session attributes (updated during this request)", this.sessionAttributeUpdatedValueMap);
        }
    }

    @RequiresNonNull(value={"sessionAttributeUpdatedValueMap"})
    private void addMidRequestSessionAttributeDetail(Map<String, Object> detail) {
        HashMap<String, String> sessionAttributeInitialValuePlusMap = new HashMap<String, String>();
        sessionAttributeInitialValuePlusMap.putAll(this.sessionAttributeInitialValueMap);
        for (Map.Entry entry : this.sessionAttributeUpdatedValueMap.entrySet()) {
            if (this.sessionAttributeInitialValueMap.containsKey(entry.getKey())) continue;
            sessionAttributeInitialValuePlusMap.put((String)entry.getKey(), null);
        }
        detail.put("Session attributes (at beginning of this request)", sessionAttributeInitialValuePlusMap);
        detail.put("Session attributes (updated during this request)", this.sessionAttributeUpdatedValueMap);
    }

    @Nullable
    static String maskRequestQueryString(@Nullable String requestQueryString, List<Pattern> maskPatterns) {
        if (requestQueryString == null) {
            return null;
        }
        if (maskPatterns.isEmpty()) {
            return requestQueryString;
        }
        StringBuilder sb = new StringBuilder(requestQueryString.length());
        boolean existMaskedParameters = false;
        int keyStartIndex = 0;
        boolean inMaskedValue = false;
        block4: for (int i = 0; i < requestQueryString.length(); ++i) {
            char c = requestQueryString.charAt(i);
            switch (c) {
                case '&': {
                    sb.append('&');
                    keyStartIndex = sb.length();
                    inMaskedValue = false;
                    continue block4;
                }
                case '=': {
                    if (keyStartIndex == -1) {
                        if (inMaskedValue) continue block4;
                        sb.append(c);
                        continue block4;
                    }
                    String key = sb.substring(keyStartIndex, sb.length());
                    sb.append('=');
                    String keyLowerCase = key.toLowerCase(Locale.ENGLISH);
                    if (DetailCapture.matchesOneOf(keyLowerCase, maskPatterns)) {
                        inMaskedValue = true;
                        sb.append(MASK_TEXT);
                        existMaskedParameters = true;
                    }
                    keyStartIndex = -1;
                    continue block4;
                }
                default: {
                    if (inMaskedValue) continue block4;
                    sb.append(c);
                }
            }
        }
        if (existMaskedParameters) {
            return sb.toString();
        }
        return requestQueryString;
    }

    @Nullable
    private static Map<String, Object> maskRequestParameters(@Nullable Map<String, Object> requestParameters, List<Pattern> maskPatterns) {
        if (requestParameters == null) {
            return null;
        }
        if (maskPatterns.isEmpty()) {
            return requestParameters;
        }
        LinkedHashMap<String, Object> maskedRequestParameters = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : requestParameters.entrySet()) {
            String name = entry.getKey();
            String keyLowerCase = name.toLowerCase(Locale.ENGLISH);
            if (DetailCapture.matchesOneOf(keyLowerCase, maskPatterns)) {
                maskedRequestParameters.put(name, MASK_TEXT);
                continue;
            }
            maskedRequestParameters.put(name, entry.getValue());
        }
        return maskedRequestParameters;
    }
}

