/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jakartaservlet;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.FastThreadLocal;
import org.glowroot.agent.plugin.api.weaving.BindClassMeta;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.jakartaservlet.ContainerStartup;
import org.glowroot.agent.plugin.jakartaservlet.DetailCapture;
import org.glowroot.agent.plugin.jakartaservlet.HttpSessions;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.RequestHostAndPortDetail;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.RequestInvoker;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.ResponseInvoker;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.SendError;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.ServletMessageSupplier;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.ServletPluginProperties;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.Strings;

public class ServletAspect {

    @Pointcut(className="jakarta.servlet.Servlet", methodName="init", methodParameterTypes={"jakarta.servlet.ServletConfig"})
    public static class ServiceInitAdvice {
        @OnBefore
        public static void onBefore() {
            ContainerStartup.initPlatformMBeanServer();
        }
    }

    @Pointcut(className="jakarta.servlet.http.HttpServletRequest", methodName="getSession", methodParameterTypes={"boolean"}, nestingGroup="servlet-inner-call")
    public static class GetSessionOneArgAdvice {
        @OnReturn
        public static void onReturn(@BindReturn @Nullable HttpSession session, ThreadContext context) {
            GetSessionAdvice.onReturn(session, context);
        }
    }

    @Pointcut(className="jakarta.servlet.http.HttpServletRequest", methodName="getSession", methodParameterTypes={}, nestingGroup="servlet-inner-call")
    public static class GetSessionAdvice {
        @OnReturn
        public static void onReturn(@BindReturn @Nullable HttpSession session, ThreadContext context) {
            ServletMessageSupplier messageSupplier;
            if (session == null) {
                return;
            }
            if (ServletPluginProperties.sessionUserAttributeIsId()) {
                context.setTransactionUser(session.getId(), -100);
            }
            if (ServletPluginProperties.captureSessionAttributeNamesContainsId() && (messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo()) != null) {
                messageSupplier.putSessionAttributeChangedValue("::id", session.getId());
            }
        }
    }

    @Pointcut(className="jakarta.servlet.http.HttpServletRequest", methodName="getUserPrincipal", methodParameterTypes={}, methodReturnType="java.security.Principal", nestingGroup="servlet-inner-call")
    public static class GetUserPrincipalAdvice {
        @OnReturn
        public static void onReturn(@BindReturn @Nullable Principal principal, ThreadContext context) {
            if (principal != null) {
                context.setTransactionUser(principal.getName(), -100);
            }
        }
    }

    @Pointcut(className="jakarta.servlet.http.HttpServletResponse", methodName="setStatus", methodParameterTypes={"int", ".."}, nestingGroup="servlet-inner-call")
    public static class SetStatusAdvice {
        @OnAfter
        public static void onAfter(ThreadContext context, @BindParameter int statusCode) {
            FastThreadLocal.Holder<String> errorMessageHolder;
            ServletMessageSupplier messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo();
            if (messageSupplier != null) {
                messageSupplier.setResponseCode(statusCode);
            }
            if (SendErrorAdvice.captureAsError(statusCode) && (errorMessageHolder = SendError.getErrorMessageHolder()).get() == null) {
                context.addErrorEntry("setStatus, HTTP status code " + statusCode);
                errorMessageHolder.set("setStatus, HTTP status code " + statusCode);
            }
        }
    }

    @Pointcut(className="jakarta.servlet.http.HttpServletResponse", methodName="sendRedirect", methodParameterTypes={"java.lang.String"}, nestingGroup="servlet-inner-call")
    public static class SendRedirectAdvice {
        @OnAfter
        public static void onAfter(ThreadContext context, @BindReceiver HttpServletResponse response, @BindParameter @Nullable String location, @BindClassMeta ResponseInvoker responseInvoker) {
            ServletMessageSupplier messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo();
            if (messageSupplier != null) {
                messageSupplier.setResponseCode(302);
                if (responseInvoker.hasGetHeaderMethod()) {
                    String header = responseInvoker.getHeader(response, "Location");
                    messageSupplier.addResponseHeader("Location", header);
                } else if (location != null) {
                    messageSupplier.addResponseHeader("Location", location);
                }
            }
        }
    }

    @Pointcut(className="jakarta.servlet.http.HttpServletResponse", methodName="sendError", methodParameterTypes={"int", ".."}, nestingGroup="servlet-inner-call")
    public static class SendErrorAdvice {
        @OnAfter
        public static void onAfter(ThreadContext context, @BindParameter int statusCode) {
            FastThreadLocal.Holder<String> errorMessageHolder;
            ServletMessageSupplier messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo();
            if (messageSupplier != null) {
                messageSupplier.setResponseCode(statusCode);
            }
            if (SendErrorAdvice.captureAsError(statusCode) && (errorMessageHolder = SendError.getErrorMessageHolder()).get() == null) {
                context.addErrorEntry("sendError, HTTP status code " + statusCode);
                errorMessageHolder.set("sendError, HTTP status code " + statusCode);
            }
        }

        private static boolean captureAsError(int statusCode) {
            return statusCode >= 500 || ServletPluginProperties.traceErrorOn4xxResponseCode() && statusCode >= 400;
        }
    }

    @Pointcut(className="jakarta.servlet.Servlet", subTypeRestriction="com.github.tomakehurst.wiremock.jetty9.JettyHandlerDispatchingServlet", methodName="service", methodParameterTypes={"jakarta.servlet.ServletRequest", "jakarta.servlet.ServletResponse"}, nestingGroup="outer-servlet-or-filter", timerName="http request", order=-1)
    public static class WireMockAdvice {
        @OnBefore
        @Nullable
        public static TraceEntry onBefore(OptionalThreadContext context, @BindParameter @Nullable ServletRequest req, @BindClassMeta RequestInvoker requestInvoker) {
            return ServiceAdvice.onBeforeCommon(context, req, "WireMock", requestInvoker);
        }

        @OnReturn
        public static void onReturn(OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res, @BindClassMeta ResponseInvoker responseInvoker) {
            ServiceAdvice.onReturn(context, traceEntry, req, res, responseInvoker);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res) {
            ServiceAdvice.onThrow(t, context, traceEntry, req, res);
        }
    }

    @Pointcut(className="org.eclipse.jetty.server.Handler|wiremock.org.eclipse.jetty.server.Handler", subTypeRestriction="/(?!org\\.eclipse\\.jetty.)(?!wiremock.org\\.eclipse\\.jetty.).*/", methodName="handle", methodParameterTypes={"java.lang.String", "org.eclipse.jetty.server.Request|wiremock.org.eclipse.jetty.server.Request", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse"}, nestingGroup="outer-servlet-or-filter", timerName="http request")
    public static class JettyHandlerAdvice {
        @OnBefore
        @Nullable
        public static TraceEntry onBefore(OptionalThreadContext context, @BindParameter @Nullable String target, @BindParameter @Nullable Object baseRequest, @BindParameter @Nullable ServletRequest req, @BindClassMeta RequestInvoker requestInvoker) {
            return ServiceAdvice.onBeforeCommon(context, req, null, requestInvoker);
        }

        @OnReturn
        public static void onReturn(OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable String target, @BindParameter @Nullable Object baseRequest, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res, @BindClassMeta ResponseInvoker responseInvoker) {
            ServiceAdvice.onReturn(context, traceEntry, req, res, responseInvoker);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable String target, @BindParameter @Nullable Object baseRequest, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res) {
            ServiceAdvice.onThrow(t, context, traceEntry, req, res);
        }
    }

    @Pointcut(className="jakarta.servlet.Filter", methodName="doFilter", methodParameterTypes={"jakarta.servlet.ServletRequest", "jakarta.servlet.ServletResponse", "jakarta.servlet.FilterChain"}, nestingGroup="outer-servlet-or-filter", timerName="http request")
    public static class DoFilterAdvice {
        @OnBefore
        @Nullable
        public static TraceEntry onBefore(OptionalThreadContext context, @BindParameter @Nullable ServletRequest req, @BindClassMeta RequestInvoker requestInvoker) {
            return ServiceAdvice.onBeforeCommon(context, req, null, requestInvoker);
        }

        @OnReturn
        public static void onReturn(OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res, @BindClassMeta ResponseInvoker responseInvoker) {
            ServiceAdvice.onReturn(context, traceEntry, req, res, responseInvoker);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res) {
            ServiceAdvice.onThrow(t, context, traceEntry, req, res);
        }
    }

    @Pointcut(className="jakarta.servlet.Servlet", methodName="service", methodParameterTypes={"jakarta.servlet.ServletRequest", "jakarta.servlet.ServletResponse"}, nestingGroup="outer-servlet-or-filter", timerName="http request")
    public static class ServiceAdvice {
        private static final TimerName timerName = Agent.getTimerName(ServiceAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(OptionalThreadContext context, @BindParameter @Nullable ServletRequest req, @BindClassMeta RequestInvoker requestInvoker) {
            return ServiceAdvice.onBeforeCommon(context, req, null, requestInvoker);
        }

        @OnReturn
        public static void onReturn(OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res, @BindClassMeta ResponseInvoker responseInvoker) {
            FastThreadLocal.Holder<String> errorMessageHolder;
            String errorMessage;
            if (traceEntry == null) {
                return;
            }
            if (!(res instanceof HttpServletResponse)) {
                return;
            }
            ServletMessageSupplier messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo();
            if (messageSupplier != null && responseInvoker.hasGetStatusMethod()) {
                messageSupplier.setResponseCode(responseInvoker.getStatus(res));
            }
            if ((errorMessage = (errorMessageHolder = SendError.getErrorMessageHolder()).get()) != null) {
                traceEntry.endWithError(errorMessage);
                errorMessageHolder.set(null);
            } else {
                traceEntry.end();
            }
            context.setServletRequestInfo(null);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, OptionalThreadContext context, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable ServletRequest req, @BindParameter @Nullable ServletResponse res) {
            if (traceEntry == null) {
                return;
            }
            if (res == null || !(res instanceof HttpServletResponse)) {
                return;
            }
            ServletMessageSupplier messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo();
            if (messageSupplier != null) {
                messageSupplier.setResponseCode(500);
            }
            SendError.clearErrorMessage();
            traceEntry.endWithError(t);
            context.setServletRequestInfo(null);
        }

        @Nullable
        private static TraceEntry onBeforeCommon(OptionalThreadContext context, @Nullable ServletRequest req, @Nullable String transactionTypeOverride, RequestInvoker requestInvoker) {
            String transactionType;
            ServletPluginProperties.SessionAttributePath userAttributePath;
            ServletMessageSupplier messageSupplier;
            if (context.getServletRequestInfo() != null) {
                return null;
            }
            if (!(req instanceof HttpServletRequest)) {
                return null;
            }
            HttpServletRequest request = (HttpServletRequest)req;
            AuxThreadContext auxContextObj = (AuxThreadContext)request.getAttribute("glowroot$auxContext");
            if (auxContextObj != null) {
                request.removeAttribute("glowroot$auxContext");
                AuxThreadContext auxContext = auxContextObj;
                return auxContext.startAndMarkAsyncTransactionComplete();
            }
            HttpSession session = request.getSession(false);
            String requestUri = Strings.nullToEmpty(request.getRequestURI());
            String requestQueryString = request.getQueryString();
            String requestMethod = Strings.nullToEmpty(request.getMethod());
            String requestContextPath = Strings.nullToEmpty(request.getContextPath());
            String requestServletPath = Strings.nullToEmpty(request.getServletPath());
            String requestPathInfo = request.getPathInfo();
            Map<String, Object> requestHeaders = DetailCapture.captureRequestHeaders(request);
            RequestHostAndPortDetail requestHostAndPortDetail = DetailCapture.captureRequestHostAndPortDetail(request, requestInvoker);
            if (session == null) {
                messageSupplier = new ServletMessageSupplier(requestMethod, requestContextPath, requestServletPath, requestPathInfo, requestUri, requestQueryString, requestHeaders, requestHostAndPortDetail, Collections.emptyMap());
            } else {
                Map<String, String> sessionAttributes = HttpSessions.getSessionAttributes(session);
                messageSupplier = new ServletMessageSupplier(requestMethod, requestContextPath, requestServletPath, requestPathInfo, requestUri, requestQueryString, requestHeaders, requestHostAndPortDetail, sessionAttributes);
            }
            String user = null;
            if (session != null && (userAttributePath = ServletPluginProperties.userAttributePath()) != null) {
                Object val = HttpSessions.getSessionAttribute(session, userAttributePath);
                user = val == null ? null : val.toString();
            }
            boolean setWithCoreMaxPriority = false;
            String transactionTypeHeader = request.getHeader("Glowroot-Transaction-Type");
            if ("Synthetic".equals(transactionTypeHeader)) {
                transactionType = transactionTypeHeader;
                setWithCoreMaxPriority = true;
            } else {
                transactionType = transactionTypeOverride != null ? transactionTypeOverride : "Web";
            }
            TraceEntry traceEntry = context.startTransaction(transactionType, requestUri, messageSupplier, timerName);
            if (setWithCoreMaxPriority) {
                context.setTransactionType(transactionType, 1000000);
            }
            context.setServletRequestInfo(messageSupplier);
            String transactionNameOverride = request.getHeader("Glowroot-Transaction-Name");
            if (transactionNameOverride != null) {
                context.setTransactionName(transactionNameOverride, 1000000);
            }
            if (user != null) {
                context.setTransactionUser(user, -100);
            }
            return traceEntry;
        }
    }
}

