/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.executor;

import java.util.Collection;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.ParameterHolder;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindClassMeta;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.executor.CallableWrapper;
import org.glowroot.agent.plugin.executor.FutureClassMeta;
import org.glowroot.agent.plugin.executor.RunnableWrapper;

public class ExecutorAspect {
    private static final Logger logger = Logger.getLogger(ExecutorAspect.class);
    private static final String EXECUTOR_CLASSES = "java.util.concurrent.Executor|java.util.concurrent.ExecutorService|org.springframework.core.task.AsyncTaskExecutor|org.springframework.core.task.AsyncListenableTaskExecutor";
    private static final AtomicBoolean isDoneExceptionLogged = new AtomicBoolean();

    private static void onBeforeWithRunnableHolder(ThreadContext context, ParameterHolder<Runnable> runnableHolder) {
        Runnable runnable = runnableHolder.get();
        if (runnable instanceof SuppressedRunnableMixin) {
            return;
        }
        if (runnable instanceof RunnableEtcMixin) {
            ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)((Object)runnable));
        } else if (runnable != null && (runnable.getClass().getName().contains("$$Lambda/") || runnable.getClass().getName().contains("$$Lambda$"))) {
            ExecutorAspect.wrapRunnable(runnableHolder, context);
        }
    }

    private static <T> void onBeforeWithCallableHolder(ThreadContext context, ParameterHolder<Callable<T>> callableHolder) {
        Callable<T> callable = callableHolder.get();
        if (callable instanceof RunnableEtcMixin) {
            ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)((Object)callable));
        } else if (callable != null && callable.getClass().getName().contains("$$Lambda$")) {
            ExecutorAspect.wrapCallable(callableHolder, context);
        }
    }

    private static void onThreadInitCommon(ThreadContext context, Thread thread) {
        if (thread instanceof RunnableEtcMixin && !(thread instanceof SuppressedRunnableMixin)) {
            ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)((Object)thread));
        }
    }

    private static boolean onThreadInitCommon(ThreadContext context, ParameterHolder<Runnable> runnableHolder) {
        Runnable runnable = runnableHolder.get();
        if (!(runnable instanceof SuppressedRunnableMixin)) {
            if (runnable instanceof RunnableEtcMixin) {
                ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)((Object)runnable));
                return true;
            }
            if (runnable != null && runnable.getClass().getName().contains("$$Lambda$")) {
                ExecutorAspect.wrapRunnable(runnableHolder, context);
                return true;
            }
        }
        return false;
    }

    private static void onBeforeCommon(ThreadContext context, RunnableEtcMixin runnableEtc) {
        RunnableEtcMixin runnableMixin = runnableEtc;
        AuxThreadContext auxContext = context.createAuxThreadContext();
        runnableMixin.glowroot$setAuxContext(auxContext);
    }

    private static void wrapRunnable(ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
        Runnable runnable = runnableHolder.get();
        if (runnable != null) {
            runnableHolder.set(new RunnableWrapper(runnable, context.createAuxThreadContext()));
        }
    }

    private static <T> void wrapCallable(ParameterHolder<Callable<T>> callableHolder, ThreadContext context) {
        Callable<T> callable = callableHolder.get();
        if (callable != null) {
            callableHolder.set(new CallableWrapper<T>(callable, context.createAuxThreadContext()));
        }
    }

    @Pointcut(className="java.util.concurrent.ForkJoinTask|akka.jsr166y.ForkJoinTask|scala.concurrent.forkjoin.ForkJoinTask", methodName="exec", methodParameterTypes={}, nestingGroup="executor-run")
    public static class ExecAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver Object task) {
            if (!(task instanceof RunnableEtcMixin)) {
                return false;
            }
            RunnableEtcMixin taskMixin = (RunnableEtcMixin)task;
            return taskMixin.glowroot$getAuxContext() != null;
        }

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(@BindReceiver Object task) {
            RunnableEtcMixin taskMixin = (RunnableEtcMixin)task;
            AuxThreadContext auxContext = taskMixin.glowroot$getAuxContext();
            if (auxContext == null) {
                return null;
            }
            taskMixin.glowroot$setAuxContext(null);
            return auxContext.start();
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="org.glowroot.agent.plugin.executor.CallableWrapper", methodName="call", methodParameterTypes={}, nestingGroup="executor-run")
    public static class CallableWrapperAdvice {
    }

    @Pointcut(className="org.glowroot.agent.plugin.executor.RunnableWrapper", methodName="run", methodParameterTypes={}, nestingGroup="executor-run")
    public static class RunnableWrapperAdvice {
    }

    @Pointcut(className="java.util.concurrent.Callable", methodName="call", methodParameterTypes={}, nestingGroup="executor-run")
    public static class CallableAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver Callable<?> callable) {
            if (!(callable instanceof RunnableEtcMixin)) {
                return false;
            }
            RunnableEtcMixin callableMixin = (RunnableEtcMixin)((Object)callable);
            return callableMixin.glowroot$getAuxContext() != null;
        }

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(@BindReceiver Callable<?> callable) {
            RunnableEtcMixin callableMixin = (RunnableEtcMixin)((Object)callable);
            AuxThreadContext auxContext = callableMixin.glowroot$getAuxContext();
            if (auxContext == null) {
                return null;
            }
            callableMixin.glowroot$setAuxContext(null);
            return auxContext.start();
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="java.lang.Runnable", methodName="run", methodParameterTypes={}, nestingGroup="executor-run")
    public static class RunnableAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver Runnable runnable) {
            if (!(runnable instanceof RunnableEtcMixin)) {
                return false;
            }
            RunnableEtcMixin runnableMixin = (RunnableEtcMixin)((Object)runnable);
            return runnableMixin.glowroot$getAuxContext() != null;
        }

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(@BindReceiver Runnable runnable) {
            RunnableEtcMixin runnableMixin = (RunnableEtcMixin)((Object)runnable);
            AuxThreadContext auxContext = runnableMixin.glowroot$getAuxContext();
            if (auxContext == null) {
                return null;
            }
            runnableMixin.glowroot$setAuxContext(null);
            return auxContext.start();
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="java.util.concurrent.Future", methodName="get", methodParameterTypes={".."}, timerName="wait on future", suppressibleUsingKey="wait-on-future")
    public static class FutureGetAdvice {
        private static final TimerName timerName = Agent.getTimerName(FutureGetAdvice.class);

        @IsEnabled
        public static boolean isEnabled(@BindReceiver Future<?> future, @BindClassMeta FutureClassMeta futureClassMeta) {
            if (futureClassMeta.isNonStandardFuture()) {
                return false;
            }
            try {
                return !future.isDone();
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
                if (!isDoneExceptionLogged.getAndSet(true)) {
                    logger.info("encountered a non-standard java.util.concurrent.Future implementation, please report this stack trace to the Glowroot project:", e);
                }
                return false;
            }
        }

        @OnBefore
        public static Timer onBefore(ThreadContext context) {
            return context.startTimer(timerName);
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    @Pointcut(className="javax.servlet.AsyncContext|jakarta.servlet.AsyncContext", methodName="start", methodParameterTypes={"java.lang.Runnable"})
    public static class StartAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter ParameterHolder<Runnable> runnableHolder) {
            ExecutorAspect.onBeforeWithRunnableHolder(context, runnableHolder);
        }
    }

    @Pointcut(className="org.eclipse.jetty.io.SelectorManager|org.eclipse.jetty.server.AbstractConnector|wiremock.org.eclipse.jetty.io.SelectorManager|wiremock.org.eclipse.jetty.server.AbstractConnector", methodName="doStart", methodParameterTypes={}, nestingGroup="executor-execute")
    public static class JettyDoStartAdvice {
    }

    @Pointcut(className="net.sf.ehcache.store.disk.DiskStorageFactory", methodName="schedule", methodParameterTypes={"java.util.concurrent.Callable"}, nestingGroup="executor-execute")
    public static class EhcacheDiskStorageScheduleAdvice {
    }

    @Pointcut(className="java.util.Timer", methodName="schedule", methodParameterTypes={"java.util.TimerTask", ".."}, nestingGroup="executor-execute")
    public static class TimerScheduleAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindParameter Object runnableEtc) {
            return runnableEtc instanceof RunnableEtcMixin;
        }

        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter TimerTask timerTask) {
            ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)((Object)timerTask));
        }
    }

    @Pointcut(className="akka.actor.Scheduler", methodName="scheduleOnce", methodParameterTypes={"scala.concurrent.duration.FiniteDuration", "java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ScheduleOnceAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter Object duration, @BindParameter ParameterHolder<Runnable> runnableHolder) {
            ExecutorAspect.onBeforeWithRunnableHolder(context, runnableHolder);
        }
    }

    @Pointcut(className="java.util.concurrent.ScheduledExecutorService", methodName="schedule", methodParameterTypes={"java.util.concurrent.Callable", ".."}, nestingGroup="executor-execute")
    public static class ScheduleCallableAdvice {
        @OnBefore
        public static <T> void onBefore(ThreadContext context, @BindParameter ParameterHolder<Callable<T>> callableHolder) {
            ExecutorAspect.onBeforeWithCallableHolder(context, callableHolder);
        }
    }

    @Pointcut(className="java.util.concurrent.ScheduledExecutorService", methodName="schedule", methodParameterTypes={"java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ScheduleRunnableAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter ParameterHolder<Runnable> runnableHolder) {
            ExecutorAspect.onBeforeWithRunnableHolder(context, runnableHolder);
        }
    }

    @Pointcut(className="java.util.concurrent.ExecutorService|java.util.concurrent.ForkJoinPool|akka.jsr166y.ForkJoinPool|scala.concurrent.forkjoin.ForkJoinPool", methodName="invokeAll|invokeAny", methodParameterTypes={"java.util.Collection", ".."}, nestingGroup="executor-execute")
    public static class InvokeAnyAllAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter Collection<?> callables) {
            if (callables == null) {
                return;
            }
            for (Object callable : callables) {
                if (!(callable instanceof RunnableEtcMixin)) continue;
                RunnableEtcMixin callableMixin = (RunnableEtcMixin)callable;
                AuxThreadContext auxContext = context.createAuxThreadContext();
                callableMixin.glowroot$setAuxContext(auxContext);
            }
        }
    }

    @Pointcut(className="com.google.common.util.concurrent.ListenableFuture", methodName="addListener", methodParameterTypes={"java.lang.Runnable", "java.util.concurrent.Executor"}, nestingGroup="executor-add-listener")
    public static class AddListenerAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter ParameterHolder<Runnable> runnableHolder) {
            ExecutorAspect.onBeforeWithRunnableHolder(context, runnableHolder);
        }
    }

    @Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.ThreadGroup", "java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ThreadInitWithThreadGroupAdvice {
        @OnBefore
        public static boolean onBefore(ThreadContext context, @BindParameter ThreadGroup threadGroup, @BindParameter ParameterHolder<Runnable> runnableHolder) {
            return ExecutorAspect.onThreadInitCommon(context, runnableHolder);
        }

        @OnReturn
        public static void onReturn(ThreadContext context, @BindTraveler boolean alreadyHandled, @BindReceiver Thread thread) {
            if (!alreadyHandled && thread instanceof RunnableEtcMixin) {
                ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)((Object)thread));
            }
        }
    }

    @Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ThreadInitWithRunnableAdvice {
        @OnBefore
        public static boolean onBefore(ThreadContext context, @BindParameter ParameterHolder<Runnable> runnableHolder) {
            return ExecutorAspect.onThreadInitCommon(context, runnableHolder);
        }

        @OnReturn
        public static void onReturn(ThreadContext context, @BindTraveler boolean alreadyHandled, @BindReceiver Thread thread) {
            if (!alreadyHandled && thread instanceof RunnableEtcMixin) {
                ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)((Object)thread));
            }
        }
    }

    @Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.ThreadGroup", "java.lang.String"}, nestingGroup="executor-execute")
    public static class ThreadInitWithStringAndThreadGroupAdvice {
        @OnReturn
        public static void onReturn(ThreadContext context, @BindReceiver Thread thread) {
            ExecutorAspect.onThreadInitCommon(context, thread);
        }
    }

    @Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.String"}, nestingGroup="executor-execute")
    public static class ThreadInitWithStringAdvice {
        @OnReturn
        public static void onReturn(ThreadContext context, @BindReceiver Thread thread) {
            ExecutorAspect.onThreadInitCommon(context, thread);
        }
    }

    @Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={}, nestingGroup="executor-execute")
    public static class ThreadInitAdvice {
        @OnReturn
        public static void onReturn(ThreadContext context, @BindReceiver Thread thread) {
            ExecutorAspect.onThreadInitCommon(context, thread);
        }
    }

    @Pointcut(className="scala.concurrent.forkjoin.ForkJoinPool", methodName="execute|submit|invoke", methodParameterTypes={"scala.concurrent.forkjoin.ForkJoinTask", ".."}, nestingGroup="executor-execute")
    public static class ScalaForkJoinPoolAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindParameter Object forkJoinTask) {
            return forkJoinTask instanceof RunnableEtcMixin;
        }

        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter Object forkJoinTask) {
            ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)forkJoinTask);
        }
    }

    @Pointcut(className="akka.jsr166y.ForkJoinPool", methodName="execute|submit|invoke", methodParameterTypes={"akka.jsr166y.ForkJoinTask", ".."}, nestingGroup="executor-execute")
    public static class AkkaJsr166yForkJoinPoolAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindParameter Object forkJoinTask) {
            return forkJoinTask instanceof RunnableEtcMixin;
        }

        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter Object forkJoinTask) {
            ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)forkJoinTask);
        }
    }

    @Pointcut(className="java.util.concurrent.ForkJoinPool", methodName="execute|submit|invoke", methodParameterTypes={"java.util.concurrent.ForkJoinTask", ".."}, nestingGroup="executor-execute")
    public static class ForkJoinPoolAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindParameter Object forkJoinTask) {
            return forkJoinTask instanceof RunnableEtcMixin;
        }

        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter Object forkJoinTask) {
            ExecutorAspect.onBeforeCommon(context, (RunnableEtcMixin)forkJoinTask);
        }
    }

    @Pointcut(className="java.util.concurrent.Executor|java.util.concurrent.ExecutorService|org.springframework.core.task.AsyncTaskExecutor|org.springframework.core.task.AsyncListenableTaskExecutor", methodName="execute|submit|submitListenable", methodParameterTypes={"java.util.concurrent.Callable", ".."}, nestingGroup="executor-execute")
    public static class ExecuteCallableAdvice {
        @OnBefore
        public static <T> void onBefore(ThreadContext context, @BindParameter ParameterHolder<Callable<T>> callableHolder) {
            ExecutorAspect.onBeforeWithCallableHolder(context, callableHolder);
        }
    }

    @Pointcut(className="java.util.concurrent.Executor|java.util.concurrent.ExecutorService|org.springframework.core.task.AsyncTaskExecutor|org.springframework.core.task.AsyncListenableTaskExecutor", methodName="execute|submit|submitListenable", methodParameterTypes={"java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ExecuteRunnableAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter ParameterHolder<Runnable> runnableHolder) {
            ExecutorAspect.onBeforeWithRunnableHolder(context, runnableHolder);
        }
    }

    public static interface SuppressedRunnableMixin {
    }

    public static interface RunnableEtcMixin {
        @Nullable
        public AuxThreadContext glowroot$getAuxContext();

        public void glowroot$setAuxContext(@Nullable AuxThreadContext var1);
    }

    @Mixin(value={"org.apache.tomcat.util.net.JIoEndpoint$SocketProcessor", "org.apache.http.impl.nio.client.CloseableHttpAsyncClientBase$1", "java.util.TimerThread"})
    public static class SuppressedRunnableImpl
    implements SuppressedRunnableMixin {
    }

    @Mixin(value={"java.lang.Runnable", "java.util.concurrent.Callable", "java.util.concurrent.ForkJoinTask", "akka.jsr166y.ForkJoinTask", "scala.concurrent.forkjoin.ForkJoinTask"})
    public static abstract class RunnableEtcImpl
    implements RunnableEtcMixin {
        @Nullable
        private volatile transient AuxThreadContext glowroot$auxContext;

        @Override
        @Nullable
        public AuxThreadContext glowroot$getAuxContext() {
            return this.glowroot$auxContext;
        }

        @Override
        public void glowroot$setAuxContext(@Nullable AuxThreadContext auxContext) {
            this.glowroot$auxContext = auxContext;
        }
    }
}

