/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.List;
import org.glowroot.agent.model.AggregatedTimer;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

public class MutableAggregateTimer
implements AggregatedTimer {
    private final String name;
    private final boolean extended;
    private double totalDurationNanos;
    private long count;
    private final List<MutableAggregateTimer> childTimers;

    public static MutableAggregateTimer createAuxThreadRootTimer() {
        return new MutableAggregateTimer("auxiliary thread", false);
    }

    public MutableAggregateTimer(String name, boolean extended) {
        this.name = name;
        this.extended = extended;
        this.childTimers = Lists.newArrayList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isExtended() {
        return this.extended;
    }

    public List<MutableAggregateTimer> getChildTimers() {
        return this.childTimers;
    }

    @Override
    public AggregatedTimer newChildTimer(String name, boolean extended) {
        MutableAggregateTimer childTimer = new MutableAggregateTimer(name, extended);
        this.childTimers.add(childTimer);
        return childTimer;
    }

    @Override
    public void addDataFrom(TransactionTimer timer) {
        this.count += timer.getCount();
        this.totalDurationNanos += (double)timer.getTotalNanos();
        timer.mergeChildTimersInto(this);
    }

    public AggregateOuterClass.Aggregate.Timer toProto() {
        AggregateOuterClass.Aggregate.Timer.Builder builder = AggregateOuterClass.Aggregate.Timer.newBuilder().setName(this.name).setExtended(this.extended).setTotalNanos(this.totalDurationNanos).setCount(this.count);
        for (MutableAggregateTimer childTimer : this.childTimers) {
            builder.addChildTimer(childTimer.toProto());
        }
        return builder.build();
    }
}

