/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.impl.RootTimerCollectorImpl;
import org.glowroot.agent.impl.ThreadStatsCollectorImpl;
import org.glowroot.agent.impl.TimerImpl;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.DetailMapWriter;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.model.MergedThreadTimer;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;

@Styles.Private
public class TraceCreator {
    private TraceCreator() {
    }

    public static Collector.TraceReader createTraceReaderForPartial(Transaction transaction, long captureTime, long captureTick) {
        return new TraceReaderImpl(transaction, true, captureTime, captureTick, transaction.getTraceId(), true, transaction.isPartiallyStored());
    }

    public static Collector.TraceReader createTraceReaderForCompleted(Transaction transaction, boolean slow) {
        return new TraceReaderImpl(transaction, slow, transaction.getCaptureTime(), transaction.getEndTick(), transaction.getTraceId(), false, transaction.isPartiallyStored());
    }

    public static TraceOuterClass.Trace.Header createPartialTraceHeader(Transaction transaction, long captureTime, long captureTick) {
        int entryCount = transaction.getEntryCount(captureTick);
        int queryCount = transaction.getQueryCount();
        long mainThreadProfileSampleCount = transaction.getMainThreadProfileSampleCount();
        long auxThreadProfileSampleCount = transaction.getAuxThreadProfileSampleCount();
        return TraceCreator.createTraceHeader(transaction, true, true, captureTime, captureTick, entryCount, queryCount, mainThreadProfileSampleCount, auxThreadProfileSampleCount);
    }

    public static TraceOuterClass.Trace.Header createCompletedTraceHeader(Transaction transaction) {
        int entryCount = transaction.getEntryCount(transaction.getEndTick());
        int queryCount = transaction.getQueryCount();
        long mainProfileSampleCount = transaction.getMainThreadProfileSampleCount();
        long auxProfileSampleCount = transaction.getAuxThreadProfileSampleCount();
        return TraceCreator.createTraceHeader(transaction, true, false, transaction.getCaptureTime(), transaction.getEndTick(), entryCount, queryCount, mainProfileSampleCount, auxProfileSampleCount);
    }

    public static List<TraceOuterClass.Trace.SharedQueryText> toProto(List<String> sharedQueryTexts) {
        ArrayList<TraceOuterClass.Trace.SharedQueryText> protos = Lists.newArrayList();
        for (String sharedQueryText : sharedQueryTexts) {
            protos.add(TraceOuterClass.Trace.SharedQueryText.newBuilder().setFullText(sharedQueryText).build());
        }
        return protos;
    }

    private static TraceOuterClass.Trace.Header createTraceHeader(Transaction transaction, boolean slow, boolean partial, long captureTime, long captureTick, int entryCount, int queryCount, long mainThreadProfileSampleCount, long auxThreadProfileSampleCount) {
        TraceOuterClass.Trace.Header.Builder builder = TraceOuterClass.Trace.Header.newBuilder();
        builder.setPartial(partial);
        builder.setSlow(slow);
        builder.setAsync(transaction.isAsync());
        ErrorMessage errorMessage = transaction.getErrorMessage();
        builder.setStartTime(transaction.getStartTime());
        builder.setCaptureTime(captureTime);
        builder.setDurationNanos(captureTick - transaction.getStartTick());
        builder.setTransactionType(transaction.getTransactionType());
        builder.setTransactionName(transaction.getTransactionName());
        builder.setHeadline(transaction.getHeadline());
        builder.setUser(transaction.getUser());
        for (Map.Entry<String, Collection<String>> entry : transaction.getAttributes().asMap().entrySet()) {
            builder.addAttributeBuilder().setName(entry.getKey()).addAllValue((Iterable<String>)entry.getValue());
        }
        builder.addAllDetailEntry(DetailMapWriter.toProto(transaction.getDetail()));
        List<StackTraceElement> locationStackTrace = transaction.getLocationStackTrace();
        if (locationStackTrace != null) {
            for (StackTraceElement stackTraceElement : locationStackTrace) {
                builder.addLocationStackTraceElementBuilder().setClassName(stackTraceElement.getClassName()).setMethodName(Strings.nullToEmpty(stackTraceElement.getMethodName())).setFileName(Strings.nullToEmpty(stackTraceElement.getFileName())).setLineNumber(stackTraceElement.getLineNumber()).build();
            }
        }
        if (errorMessage != null) {
            TraceOuterClass.Trace.Error.Builder builder2 = builder.getErrorBuilder();
            builder2.setMessage(errorMessage.message());
            Proto.Throwable throwable = errorMessage.throwable();
            if (throwable != null) {
                builder2.setException(throwable);
            }
            builder2.build();
        }
        TimerImpl timerImpl = transaction.getMainThreadRootTimer();
        builder.setMainThreadRootTimer(timerImpl.toProto());
        ThreadStatsCollectorImpl mainThreadStats = new ThreadStatsCollectorImpl();
        mainThreadStats.mergeThreadStats(transaction.getMainThreadStats());
        builder.setMainThreadStats(mainThreadStats.toProto());
        if (transaction.hasAuxThreadContexts()) {
            MergedThreadTimer auxThreadRootTimer = MergedThreadTimer.createAuxThreadRootTimer();
            transaction.mergeAuxThreadTimersInto(auxThreadRootTimer);
            builder.setAuxThreadRootTimer(auxThreadRootTimer.toProto());
            ThreadStatsCollectorImpl auxThreadStats = new ThreadStatsCollectorImpl();
            transaction.mergeAuxThreadStatsInto(auxThreadStats);
            builder.setAuxThreadStats(auxThreadStats.toProto());
        }
        RootTimerCollectorImpl asyncTimers = new RootTimerCollectorImpl();
        transaction.mergeAsyncTimersInto(asyncTimers);
        builder.addAllAsyncTimer(asyncTimers.toProto());
        TraceCreator.addCounts(builder, transaction, entryCount, queryCount, mainThreadProfileSampleCount, auxThreadProfileSampleCount);
        return builder.build();
    }

    private static void addCounts(TraceOuterClass.Trace.Header.Builder builder, Transaction transaction, int entryCount, int queryCount, long mainThreadProfileSampleCount, long auxThreadProfileSampleCount) {
        builder.setEntryCount(entryCount);
        builder.setEntryLimitExceeded(transaction.isEntryLimitExceeded(entryCount));
        builder.setQueryCount(queryCount);
        builder.setQueryLimitExceeded(transaction.isQueryLimitExceeded(queryCount));
        builder.setMainThreadProfileSampleCount(mainThreadProfileSampleCount);
        builder.setMainThreadProfileSampleLimitExceeded(transaction.isMainThreadProfileSampleLimitExceeded(mainThreadProfileSampleCount));
        builder.setAuxThreadProfileSampleCount(auxThreadProfileSampleCount);
        builder.setAuxThreadProfileSampleLimitExceeded(transaction.isAuxThreadProfileSampleLimitExceeded(auxThreadProfileSampleCount));
    }

    private static class CountingEntryVisitorWrapper
    implements Transaction.TraceEntryVisitor {
        private final Collector.TraceVisitor delegate;
        private int count;

        private CountingEntryVisitorWrapper(Collector.TraceVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void visitEntry(TraceOuterClass.Trace.Entry entry) {
            if (CountingEntryVisitorWrapper.countEntry(entry)) {
                ++this.count;
            }
            this.delegate.visitEntry(entry);
        }

        private static boolean countEntry(TraceOuterClass.Trace.Entry entry) {
            return !entry.getMessage().equals("auxiliary thread");
        }
    }

    private static class TraceReaderImpl
    implements Collector.TraceReader {
        private final Transaction transaction;
        private final boolean slow;
        private final long captureTime;
        private final long captureTick;
        private final String traceId;
        private final boolean partial;
        private final boolean update;
        private TraceOuterClass.Trace.Header header;

        private TraceReaderImpl(Transaction transaction, boolean slow, long captureTime, long captureTick, String traceId, boolean partial, boolean update) {
            this.transaction = transaction;
            this.slow = slow;
            this.captureTime = captureTime;
            this.captureTick = captureTick;
            this.traceId = traceId;
            this.partial = partial;
            this.update = update;
        }

        @Override
        public void accept(Collector.TraceVisitor traceVisitor) throws Exception {
            CountingEntryVisitorWrapper entryVisitorWrapper = new CountingEntryVisitorWrapper(traceVisitor);
            this.transaction.visitEntries(this.captureTick, entryVisitorWrapper);
            List<AggregateOuterClass.Aggregate.Query> queries = this.transaction.getQueries();
            traceVisitor.visitQueries(queries);
            traceVisitor.visitSharedQueryTexts(this.transaction.getSharedQueryTexts());
            ProfileOuterClass.Profile mainThreadProfile = this.transaction.getMainThreadProfileProtobuf();
            if (mainThreadProfile != null) {
                traceVisitor.visitMainThreadProfile(mainThreadProfile);
            }
            long mainThreadProfileSampleCount = TraceReaderImpl.getProfileSampleCount(mainThreadProfile);
            ProfileOuterClass.Profile auxThreadProfile = this.transaction.getAuxThreadProfileProtobuf();
            if (auxThreadProfile != null) {
                traceVisitor.visitAuxThreadProfile(auxThreadProfile);
            }
            long auxThreadProfileSampleCount = TraceReaderImpl.getProfileSampleCount(auxThreadProfile);
            int entryCount = entryVisitorWrapper.count;
            int queryCount = queries.size();
            if (this.header == null) {
                traceVisitor.visitHeader(TraceCreator.createTraceHeader(this.transaction, this.slow, this.partial, this.captureTime, this.captureTick, entryCount, queryCount, mainThreadProfileSampleCount, auxThreadProfileSampleCount));
            } else {
                TraceOuterClass.Trace.Header.Builder builder = this.header.toBuilder();
                TraceCreator.addCounts(builder, this.transaction, entryCount, queryCount, mainThreadProfileSampleCount, auxThreadProfileSampleCount);
                traceVisitor.visitHeader(builder.build());
            }
        }

        @Override
        public TraceOuterClass.Trace.Header readHeader() {
            if (this.header == null) {
                this.header = TraceCreator.createTraceHeader(this.transaction, true, this.partial, this.captureTime, this.captureTick, 0, 0, 0L, 0L);
            }
            return this.header;
        }

        @Override
        public long captureTime() {
            return this.captureTime;
        }

        @Override
        public String traceId() {
            return this.traceId;
        }

        @Override
        public boolean partial() {
            return this.partial;
        }

        @Override
        public boolean update() {
            return this.update;
        }

        private static long getProfileSampleCount( @Nullable ProfileOuterClass.Profile profile) {
            if (profile == null) {
                return 0L;
            }
            long profileSampleCount = 0L;
            for (ProfileOuterClass.Profile.ProfileNode node : profile.getNodeList()) {
                if (node.getDepth() != 0) continue;
                profileSampleCount += node.getSampleCount();
            }
            return profileSampleCount;
        }
    }
}

