/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.config.ImmutablePluginCache;
import org.glowroot.agent.config.ImmutablePluginDescriptor;
import org.glowroot.agent.config.ImmutablePropertyDescriptor;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.config.PropertyDescriptor;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterators;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PluginCache {
    private static final Logger logger = LoggerFactory.getLogger(PluginCache.class);
    private static final ObjectMapper mapper = ObjectMappers.create(new Module[0]);

    public abstract ImmutableList<File> pluginJars();

    public abstract ImmutableList<PluginDescriptor> pluginDescriptors();

    public static PluginCache create(@Nullable File pluginsDir, boolean offlineViewer) throws Exception {
        ImmutablePluginCache.Builder builder = ImmutablePluginCache.builder();
        ImmutableList<File> pluginJars = PluginCache.getPluginJars(pluginsDir);
        builder.addAllPluginJars(pluginJars);
        ArrayList<PluginDescriptor> unsortedPluginDescriptors = Lists.newArrayList();
        if (offlineViewer) {
            unsortedPluginDescriptors.addAll(PluginCache.createForOfflineViewer(pluginJars, pluginsDir));
        } else {
            unsortedPluginDescriptors.addAll(PluginCache.readPluginDescriptors(pluginJars, pluginsDir));
        }
        URL plugins = PluginCache.class.getResource("/META-INF/glowroot.plugins.json");
        if (plugins != null) {
            List<ImmutablePluginDescriptor> pluginDescriptors = mapper.readValue(plugins, new TypeReference<List<ImmutablePluginDescriptor>>(){});
            Preconditions.checkNotNull(pluginDescriptors);
            unsortedPluginDescriptors.addAll(pluginDescriptors);
        }
        return builder.addAllPluginDescriptors(new PluginDescriptorOrdering().sortedCopy(unsortedPluginDescriptors)).build();
    }

    private static ImmutableList<File> getPluginJars(@Nullable File pluginsDir) {
        if (pluginsDir == null) {
            return ImmutableList.of();
        }
        File[] pluginJars = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (pluginJars == null) {
            logger.warn("listFiles() returned null on directory: {}", (Object)pluginsDir.getAbsolutePath());
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(pluginJars);
    }

    private static ImmutableList<File> getStandaloneDescriptors(@Nullable File pluginsDir) {
        if (pluginsDir == null) {
            return ImmutableList.of();
        }
        File[] pluginDescriptorFiles = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        });
        if (pluginDescriptorFiles == null) {
            logger.warn("listFiles() returned null on directory: {}", (Object)pluginsDir.getAbsolutePath());
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(pluginDescriptorFiles);
    }

    private static ImmutableList<URL> getResources(String resourceName) throws IOException {
        ClassLoader loader = PluginCache.class.getClassLoader();
        if (loader == null) {
            return ImmutableList.copyOf(Iterators.forEnumeration(ClassLoader.getSystemResources(resourceName)));
        }
        return ImmutableList.copyOf(Iterators.forEnumeration(loader.getResources(resourceName)));
    }

    private static List<PluginDescriptor> createForOfflineViewer(List<File> pluginJars, @Nullable File pluginsDir) throws IOException {
        List<PluginDescriptor> pluginDescriptors = PluginCache.readPluginDescriptors(pluginJars, pluginsDir);
        ArrayList<PluginDescriptor> pluginDescriptorsWithoutAdvice = Lists.newArrayList();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            pluginDescriptorsWithoutAdvice.add(ImmutablePluginDescriptor.builder().copyFrom(pluginDescriptor).aspects(ImmutableList.of()).build());
        }
        return pluginDescriptorsWithoutAdvice;
    }

    private static List<PluginDescriptor> readPluginDescriptors(List<File> pluginJars, @Nullable File pluginsDir) throws IOException {
        ArrayList<PluginDescriptor> pluginDescriptors = Lists.newArrayList();
        for (File pluginJar : pluginJars) {
            URL url = new URL("jar:" + pluginJar.toURI() + "!/META-INF/glowroot.plugin.json");
            PluginCache.buildPluginDescriptor(url, pluginJar, pluginDescriptors);
        }
        for (File file : PluginCache.getStandaloneDescriptors(pluginsDir)) {
            PluginCache.buildPluginDescriptor(file.toURI().toURL(), null, pluginDescriptors);
        }
        for (URL url : PluginCache.getResources("META-INF/glowroot.plugin.json")) {
            PluginCache.buildPluginDescriptor(url, null, pluginDescriptors);
        }
        return pluginDescriptors;
    }

    private static void buildPluginDescriptor(URL url, @Nullable File pluginJar, List<PluginDescriptor> pluginDescriptors) throws IOException {
        ImmutablePluginDescriptor pluginDescriptor;
        String content = Resources.toString(url, Charsets.UTF_8);
        try {
            pluginDescriptor = mapper.readValue(content, ImmutablePluginDescriptor.class);
        }
        catch (JsonProcessingException e) {
            logger.error("error parsing plugin descriptor: {}", (Object)url.toExternalForm(), (Object)e);
            return;
        }
        pluginDescriptors.add(pluginDescriptor.withPluginJar(pluginJar));
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addAbstractTypeMapping(InstrumentationConfig.class, ImmutableInstrumentationConfig.class);
        module.addAbstractTypeMapping(PropertyDescriptor.class, ImmutablePropertyDescriptor.class);
        mapper.registerModule(module);
    }

    private static class PluginDescriptorOrdering
    extends Ordering<PluginDescriptor> {
        private PluginDescriptorOrdering() {
        }

        @Override
        public int compare(PluginDescriptor left, PluginDescriptor right) {
            return left.id().compareToIgnoreCase(right.id());
        }
    }
}

