/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.config.PropertyDescriptor;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PluginDescriptor", generator="Immutables")
@Immutable
public final class ImmutablePluginDescriptor
extends PluginDescriptor {
    private final String id;
    private final String name;
    private final ImmutableList<PropertyDescriptor> properties;
    private final ImmutableList<InstrumentationConfig> instrumentationConfigs;
    private final ImmutableList<String> aspects;
    private final boolean collocate;
    @Nullable
    private final File pluginJar;

    private ImmutablePluginDescriptor(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.properties = builder.properties.build();
        this.instrumentationConfigs = builder.instrumentationConfigs.build();
        this.aspects = builder.aspects.build();
        this.pluginJar = builder.pluginJar;
        this.collocate = builder.collocateIsSet() ? builder.collocate : super.collocate();
    }

    private ImmutablePluginDescriptor(String id, String name, ImmutableList<PropertyDescriptor> properties, ImmutableList<InstrumentationConfig> instrumentationConfigs, ImmutableList<String> aspects, boolean collocate, @Nullable File pluginJar) {
        this.id = id;
        this.name = name;
        this.properties = properties;
        this.instrumentationConfigs = instrumentationConfigs;
        this.aspects = aspects;
        this.collocate = collocate;
        this.pluginJar = pluginJar;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="properties")
    public ImmutableList<PropertyDescriptor> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="instrumentation")
    public ImmutableList<InstrumentationConfig> instrumentationConfigs() {
        return this.instrumentationConfigs;
    }

    @Override
    @JsonProperty(value="aspects")
    public ImmutableList<String> aspects() {
        return this.aspects;
    }

    @Override
    @JsonProperty(value="collocate")
    public boolean collocate() {
        return this.collocate;
    }

    @Override
    @JsonProperty(value="pluginJar")
    @JsonIgnore
    @Nullable
    public File pluginJar() {
        return this.pluginJar;
    }

    public final ImmutablePluginDescriptor withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginDescriptor(newValue, this.name, this.properties, this.instrumentationConfigs, this.aspects, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginDescriptor(this.id, newValue, this.properties, this.instrumentationConfigs, this.aspects, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withProperties(PropertyDescriptor ... elements) {
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginDescriptor(this.id, this.name, newValue, this.instrumentationConfigs, this.aspects, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withProperties(Iterable<? extends PropertyDescriptor> elements) {
        if (this.properties == elements) {
            return this;
        }
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginDescriptor(this.id, this.name, newValue, this.instrumentationConfigs, this.aspects, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withInstrumentationConfigs(InstrumentationConfig ... elements) {
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginDescriptor(this.id, this.name, this.properties, newValue, this.aspects, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
        if (this.instrumentationConfigs == elements) {
            return this;
        }
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginDescriptor(this.id, this.name, this.properties, newValue, this.aspects, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withAspects(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginDescriptor(this.id, this.name, this.properties, this.instrumentationConfigs, newValue, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withAspects(Iterable<String> elements) {
        if (this.aspects == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginDescriptor(this.id, this.name, this.properties, this.instrumentationConfigs, newValue, this.collocate, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withCollocate(boolean value) {
        if (this.collocate == value) {
            return this;
        }
        return new ImmutablePluginDescriptor(this.id, this.name, this.properties, this.instrumentationConfigs, this.aspects, value, this.pluginJar);
    }

    public final ImmutablePluginDescriptor withPluginJar(@Nullable File value) {
        if (this.pluginJar == value) {
            return this;
        }
        return new ImmutablePluginDescriptor(this.id, this.name, this.properties, this.instrumentationConfigs, this.aspects, this.collocate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginDescriptor && this.equalTo(0, (ImmutablePluginDescriptor)another);
    }

    private boolean equalTo(int synthetic, ImmutablePluginDescriptor another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.properties.equals(another.properties) && this.instrumentationConfigs.equals(another.instrumentationConfigs) && this.aspects.equals(another.aspects) && this.collocate == another.collocate && Objects.equals(this.pluginJar, another.pluginJar);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.instrumentationConfigs.hashCode();
        h += (h << 5) + this.aspects.hashCode();
        h += (h << 5) + Booleans.hashCode(this.collocate);
        h += (h << 5) + Objects.hashCode(this.pluginJar);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginDescriptor").omitNullValues().add("id", this.id).add("name", this.name).add("properties", this.properties).add("instrumentationConfigs", this.instrumentationConfigs).add("aspects", this.aspects).add("collocate", this.collocate).add("pluginJar", this.pluginJar).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginDescriptor fromJson(Json json) {
        Builder builder = ImmutablePluginDescriptor.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.properties != null) {
            builder.addAllProperties(json.properties);
        }
        if (json.instrumentationConfigs != null) {
            builder.addAllInstrumentationConfigs(json.instrumentationConfigs);
        }
        if (json.aspects != null) {
            builder.addAllAspects(json.aspects);
        }
        if (json.collocateIsSet) {
            builder.collocate(json.collocate);
        }
        if (json.pluginJar != null) {
            builder.pluginJar(json.pluginJar);
        }
        return builder.build();
    }

    public static ImmutablePluginDescriptor copyOf(PluginDescriptor instance) {
        if (instance instanceof ImmutablePluginDescriptor) {
            return (ImmutablePluginDescriptor)instance;
        }
        return ImmutablePluginDescriptor.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PluginDescriptor", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_COLLOCATE = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private ImmutableList.Builder<PropertyDescriptor> properties = ImmutableList.builder();
        private ImmutableList.Builder<InstrumentationConfig> instrumentationConfigs = ImmutableList.builder();
        private ImmutableList.Builder<String> aspects = ImmutableList.builder();
        private boolean collocate;
        @Nullable
        private File pluginJar;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(PluginDescriptor instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            this.addAllProperties(instance.properties());
            this.addAllInstrumentationConfigs(instance.instrumentationConfigs());
            this.addAllAspects(instance.aspects());
            this.collocate(instance.collocate());
            File pluginJarValue = instance.pluginJar();
            if (pluginJarValue != null) {
                this.pluginJar(pluginJarValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(PropertyDescriptor element) {
            this.properties.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(PropertyDescriptor ... elements) {
            this.properties.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Iterable<? extends PropertyDescriptor> elements) {
            this.properties = ImmutableList.builder();
            return this.addAllProperties(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProperties(Iterable<? extends PropertyDescriptor> elements) {
            this.properties.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstrumentationConfigs(InstrumentationConfig element) {
            this.instrumentationConfigs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstrumentationConfigs(InstrumentationConfig ... elements) {
            this.instrumentationConfigs.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder instrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
            this.instrumentationConfigs = ImmutableList.builder();
            return this.addAllInstrumentationConfigs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
            this.instrumentationConfigs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAspects(String element) {
            this.aspects.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAspects(String ... elements) {
            this.aspects.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder aspects(Iterable<String> elements) {
            this.aspects = ImmutableList.builder();
            return this.addAllAspects(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAspects(Iterable<String> elements) {
            this.aspects.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collocate(boolean collocate) {
            this.collocate = collocate;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginJar(@Nullable File pluginJar) {
            this.pluginJar = pluginJar;
            return this;
        }

        public ImmutablePluginDescriptor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePluginDescriptor(this);
        }

        private boolean collocateIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build PluginDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PluginDescriptor", generator="Immutables")
    static final class Json
    extends PluginDescriptor {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        ImmutableList<PropertyDescriptor> properties = ImmutableList.of();
        @Nullable
        ImmutableList<InstrumentationConfig> instrumentationConfigs = ImmutableList.of();
        @Nullable
        ImmutableList<String> aspects = ImmutableList.of();
        boolean collocate;
        boolean collocateIsSet;
        @Nullable
        File pluginJar;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="properties")
        public void setProperties(ImmutableList<PropertyDescriptor> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="instrumentation")
        public void setInstrumentationConfigs(ImmutableList<InstrumentationConfig> instrumentationConfigs) {
            this.instrumentationConfigs = instrumentationConfigs;
        }

        @JsonProperty(value="aspects")
        public void setAspects(ImmutableList<String> aspects) {
            this.aspects = aspects;
        }

        @JsonProperty(value="collocate")
        public void setCollocate(boolean collocate) {
            this.collocate = collocate;
            this.collocateIsSet = true;
        }

        @JsonProperty(value="pluginJar")
        @JsonIgnore
        public void setPluginJar(@Nullable File pluginJar) {
            this.pluginJar = pluginJar;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<PropertyDescriptor> properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<InstrumentationConfig> instrumentationConfigs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> aspects() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean collocate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public File pluginJar() {
            throw new UnsupportedOperationException();
        }
    }
}

