/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigService.PluginConfigTemp", generator="Immutables")
@Immutable
final class ImmutablePluginConfigTemp
implements ConfigService.PluginConfigTemp {
    private final String id;
    private final ImmutableMap<String, PropertyValue> properties;

    private ImmutablePluginConfigTemp(String id, ImmutableMap<String, PropertyValue> properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @JsonProperty(value="properties")
    public ImmutableMap<String, PropertyValue> properties() {
        return this.properties;
    }

    public final ImmutablePluginConfigTemp withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginConfigTemp(newValue, this.properties);
    }

    public final ImmutablePluginConfigTemp withProperties(Map<String, ? extends PropertyValue> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap<String, PropertyValue> newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePluginConfigTemp(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginConfigTemp && this.equalTo(0, (ImmutablePluginConfigTemp)another);
    }

    private boolean equalTo(int synthetic, ImmutablePluginConfigTemp another) {
        return this.id.equals(another.id) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginConfigTemp").omitNullValues().add("id", this.id).add("properties", this.properties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginConfigTemp fromJson(Json json) {
        Builder builder = ImmutablePluginConfigTemp.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.properties != null) {
            builder.putAllProperties(json.properties);
        }
        return builder.build();
    }

    public static ImmutablePluginConfigTemp copyOf(ConfigService.PluginConfigTemp instance) {
        if (instance instanceof ImmutablePluginConfigTemp) {
            return (ImmutablePluginConfigTemp)instance;
        }
        return ImmutablePluginConfigTemp.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigService.PluginConfigTemp", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private ImmutableMap.Builder<String, PropertyValue> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigService.PluginConfigTemp instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.putAllProperties(instance.properties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, PropertyValue value) {
            this.properties.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends PropertyValue> entry) {
            this.properties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends PropertyValue> entries) {
            this.properties = ImmutableMap.builder();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends PropertyValue> entries) {
            this.properties.putAll(entries);
            return this;
        }

        public ImmutablePluginConfigTemp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePluginConfigTemp(this.id, this.properties.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build PluginConfigTemp, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigService.PluginConfigTemp", generator="Immutables")
    static final class Json
    implements ConfigService.PluginConfigTemp {
        @Nullable
        String id;
        @Nullable
        Map<String, PropertyValue> properties = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="properties")
        public void setProperties(Map<String, PropertyValue> properties) {
            this.properties = properties;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, PropertyValue> properties() {
            throw new UnsupportedOperationException();
        }
    }
}

