/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.LZFInputStream;
import org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.LZFOutputStream;
import org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.util.ChunkDecoderFactory;
import org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.util.ChunkEncoderFactory;
import org.glowroot.agent.embedded.util.CappedDatabaseOutputStream;
import org.glowroot.agent.embedded.util.CappedDatabaseStats;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.io.ByteSource;
import org.glowroot.agent.shaded.com.google.common.io.CharSource;
import org.glowroot.agent.shaded.com.google.common.io.CountingOutputStream;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.com.google.protobuf.MessageLite;
import org.glowroot.agent.shaded.com.google.protobuf.Parser;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.SizeLimitBypassingParser;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;

public class CappedDatabase {
    private static final Logger logger = LoggerFactory.getLogger(CappedDatabase.class);
    private static final boolean USE_SAFE_LZF_ENCODER;
    private final File file;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final CappedDatabaseOutputStream out;
    private final Thread shutdownHookThread;
    @GuardedBy(value="lock")
    private RandomAccessFile inFile;
    private volatile boolean closed = false;
    private final Ticker ticker;
    private final Map<String, CappedDatabaseStats> statsByType = Maps.newHashMap();

    public CappedDatabase(File file, int requestedSizeKb, @Nullable ScheduledExecutorService scheduledExecutor, Ticker ticker) throws IOException {
        this.file = file;
        this.ticker = ticker;
        this.out = CappedDatabaseOutputStream.create(file, requestedSizeKb, scheduledExecutor, ticker);
        this.inFile = new RandomAccessFile(file, "r");
        this.shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    public long writeMessage(final AbstractMessage message, String type) throws IOException {
        return this.write(type, new Copier(){

            @Override
            public void copyTo(OutputStream writer) throws IOException {
                message.writeTo(writer);
            }
        });
    }

    public long writeMessages(final List<? extends AbstractMessage> messages, String type) throws IOException {
        return this.write(type, new Copier(){

            @Override
            public void copyTo(OutputStream writer) throws IOException {
                for (AbstractMessage message : messages) {
                    message.writeDelimitedTo(writer);
                }
            }
        });
    }

    public CappedDatabaseStats getStats(String type) {
        CappedDatabaseStats stats = this.statsByType.get(type);
        if (stats == null) {
            return new CappedDatabaseStats();
        }
        return stats;
    }

    @OnlyUsedByTests
    long write(final ByteSource byteSource, String type) throws IOException {
        return this.write(type, new Copier(){

            @Override
            public void copyTo(OutputStream out) throws IOException {
                byteSource.copyTo(out);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long write(String type, Copier copier) throws IOException {
        long blockStartIndex;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return -1L;
            }
            long startTick = this.ticker.read();
            this.out.startBlock();
            NonClosingCountingOutputStream countingStreamAfterCompression = new NonClosingCountingOutputStream(this.out);
            CountingOutputStream countingStreamBeforeCompression = new CountingOutputStream((OutputStream)CappedDatabase.newLZFOutputStream(countingStreamAfterCompression));
            copier.copyTo((OutputStream)countingStreamBeforeCompression);
            countingStreamBeforeCompression.close();
            long endTick = this.ticker.read();
            CappedDatabaseStats stats = this.statsByType.get(type);
            if (stats == null) {
                stats = new CappedDatabaseStats();
                this.statsByType.put(type, stats);
            }
            stats.record(countingStreamBeforeCompression.getCount(), countingStreamAfterCompression.getCount(), endTick - startTick);
            blockStartIndex = this.out.endBlock();
        }
        this.out.fsyncIfReallyNeeded();
        return blockStartIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends AbstractMessage> T readMessage(long cappedId, Parser<T> parser) throws IOException {
        if (this.out.isOverwritten(cappedId)) {
            return null;
        }
        if (this.out.isInTheFuture(cappedId)) {
            return null;
        }
        int bufferSize = 32768;
        try (LZFInputStream input = CappedDatabase.newLZFInputStream(new BufferedInputStream(new CappedBlockInputStream(cappedId), 32768));){
            AbstractMessage abstractMessage = (AbstractMessage)parser.parseFrom((InputStream)input);
            return (T)abstractMessage;
        }
        catch (Exception e) {
            if (this.out.isOverwritten(cappedId)) return null;
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <T extends MessageLite> List<T> readMessages(long cappedId, Parser<T> parser) {
        ArrayList arrayList;
        block13: {
            if (this.out.isOverwritten(cappedId)) {
                return ImmutableList.of();
            }
            if (this.out.isInTheFuture(cappedId)) {
                return ImmutableList.of();
            }
            int bufferSize = 32768;
            LZFInputStream input = CappedDatabase.newLZFInputStream(new BufferedInputStream(new CappedBlockInputStream(cappedId), 32768));
            try {
                MessageLite message;
                SizeLimitBypassingParser sizeLimitBypassingParser = new SizeLimitBypassingParser(parser);
                ArrayList messages = Lists.newArrayList();
                while ((message = sizeLimitBypassingParser.parseDelimitedFrom((InputStream)input)) != null) {
                    messages.add(message);
                }
                arrayList = messages;
                if (input == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                catch (Exception e) {
                    if (!this.out.isOverwritten(cappedId)) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    return ImmutableList.of();
                }
            }
            ((InputStream)input).close();
        }
        return arrayList;
    }

    @OnlyUsedByTests
    CharSource read(long cappedId) {
        return new CappedBlockCharSource(cappedId);
    }

    boolean isExpired(long cappedId) {
        return this.out.isOverwritten(cappedId);
    }

    public long getSmallestNonExpiredId() {
        return this.out.getSmallestNonOverwrittenId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newSizeKb) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.inFile.close();
            this.out.resize(newSizeKb);
            this.inFile = new RandomAccessFile(this.file, "r");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyUsedByTests
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.out.close();
            this.inFile.close();
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
    }

    private static LZFOutputStream newLZFOutputStream(OutputStream outputStream) {
        if (USE_SAFE_LZF_ENCODER) {
            return new LZFOutputStream(ChunkEncoderFactory.safeInstance(), outputStream);
        }
        return new LZFOutputStream(outputStream);
    }

    private static LZFInputStream newLZFInputStream(InputStream inputStream) throws IOException {
        if (USE_SAFE_LZF_ENCODER) {
            return new LZFInputStream(ChunkDecoderFactory.safeInstance(), inputStream);
        }
        return new LZFInputStream(inputStream);
    }

    static {
        String arch = StandardSystemProperty.OS_ARCH.value();
        boolean unalignedAccessAllowed = "i386".equals(arch) || "x86".equals(arch) || "amd64".equals(arch) || "x86_64".equals(arch) || "aarch64".equals(arch) || "ppc64le".equals(arch);
        USE_SAFE_LZF_ENCODER = !unalignedAccessAllowed || JavaVersion.isJ9Jvm() && JavaVersion.isJava6();
    }

    private static class NonClosingCountingOutputStream
    extends FilterOutputStream {
        private long count;

        private NonClosingCountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.count;
        }

        @Override
        public void close() {
        }

        private long getCount() {
            return this.count;
        }
    }

    private static class CappedBlockRolledOverMidReadException
    extends IOException {
        public CappedBlockRolledOverMidReadException(String message) {
            super(message);
        }
    }

    private static interface Copier {
        public void copyTo(OutputStream var1) throws IOException;
    }

    private class ShutdownHookThread
    extends Thread {
        private ShutdownHookThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CappedDatabase.this.closed = true;
                Object object = CappedDatabase.this.lock;
                synchronized (object) {
                    CappedDatabase.this.out.close();
                    CappedDatabase.this.inFile.close();
                }
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class CappedBlockInputStream
    extends InputStream {
        private final long cappedId;
        private long blockLength = -1L;
        private long blockIndex;

        private CappedBlockInputStream(long cappedId) {
            this.cappedId = cappedId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (this.blockIndex == this.blockLength) {
                return -1;
            }
            Object object = CappedDatabase.this.lock;
            synchronized (object) {
                long filePosition;
                if (CappedDatabase.this.out.isOverwritten(this.cappedId)) {
                    throw new CappedBlockRolledOverMidReadException("Block rolled over mid-read");
                }
                if (this.blockLength == -1L) {
                    filePosition = CappedDatabase.this.out.convertToFilePosition(this.cappedId);
                    CappedDatabase.this.inFile.seek(20L + filePosition);
                    this.blockLength = CappedDatabase.this.inFile.readLong();
                }
                filePosition = CappedDatabase.this.out.convertToFilePosition(this.cappedId + 8L + this.blockIndex);
                CappedDatabase.this.inFile.seek(20L + filePosition);
                long blockRemaining = this.blockLength - this.blockIndex;
                long fileRemaining = (long)CappedDatabase.this.out.getSizeKb() * 1024L - filePosition;
                int numToRead = (int)Longs.min((long[])new long[]{len, blockRemaining, fileRemaining});
                CappedDatabase.this.inFile.readFully(bytes, off, numToRead);
                this.blockIndex += (long)numToRead;
                return numToRead;
            }
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("CappedBlockInputStream should always be wrapped in a BufferedInputStream");
        }
    }

    @OnlyUsedByTests
    private class CappedBlockCharSource
    extends CharSource {
        private final long cappedId;

        private CappedBlockCharSource(long cappedId) {
            this.cappedId = cappedId;
        }

        public Reader openStream() throws IOException {
            int bufferSize = 32768;
            return new InputStreamReader((InputStream)CappedDatabase.newLZFInputStream(new BufferedInputStream(new CappedBlockInputStream(this.cappedId), 32768)), Charsets.UTF_8);
        }
    }
}

