/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.sql;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SQLException
extends Exception
implements Iterable<Throwable> {
    private final @Nullable String sqlState;
    private final int errorCode;
    private volatile @Nullable SQLException next;

    public SQLException(String message, @Nullable String sqlState, int errorCode) {
        super(message);
        this.sqlState = sqlState;
        this.errorCode = errorCode;
    }

    public SQLException(String message, @Nullable String sqlState) {
        super(message);
        this.sqlState = sqlState;
        this.errorCode = 0;
    }

    public SQLException(String message) {
        super(message);
        this.sqlState = null;
        this.errorCode = 0;
    }

    public SQLException() {
        this.sqlState = null;
        this.errorCode = 0;
    }

    public SQLException(@Nullable Throwable cause) {
        super(cause);
        this.sqlState = null;
        this.errorCode = 0;
    }

    public SQLException(String message, @Nullable Throwable cause) {
        super(message, cause);
        this.sqlState = null;
        this.errorCode = 0;
    }

    public SQLException(String message, @Nullable String sqlState, @Nullable Throwable cause) {
        super(message, cause);
        this.sqlState = sqlState;
        this.errorCode = 0;
    }

    public SQLException(String message, @Nullable String sqlState, int errorCode, @Nullable Throwable cause) {
        super(message, cause);
        this.sqlState = sqlState;
        this.errorCode = errorCode;
    }

    public @Nullable String getSQLState() {
        return this.sqlState;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public @Nullable SQLException getNextException() {
        return this.next;
    }

    public void setNextException(SQLException exception) {
        SQLException curr = this;
        while (true) {
            SQLException next;
            if ((next = curr.next) == null) {
                curr.next = exception;
                return;
            }
            curr = next;
        }
    }

    @Override
    public Iterator<Throwable> iterator() {
        return new SQLExceptionIterator(this);
    }

    private static class SQLExceptionIterator
    implements Iterator<Throwable> {
        private @Nullable Throwable nextCause = null;
        private @Nullable SQLException nextSqlException;

        private SQLExceptionIterator(SQLException head) {
            this.nextSqlException = head;
        }

        @Override
        public boolean hasNext() {
            return this.nextCause != null || this.nextSqlException != null;
        }

        @Override
        public Throwable next() {
            Throwable currCause = this.nextCause;
            if (currCause != null) {
                this.nextCause = null;
                return currCause;
            }
            SQLException currSqlException = this.nextSqlException;
            if (currSqlException == null) {
                throw new NoSuchElementException();
            }
            this.nextCause = currSqlException.getCause();
            this.nextSqlException = currSqlException.getNextException();
            return currSqlException;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

