/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.owasp.html;

import org.glowroot.agent.embedded.shaded.org.owasp.html.AttributePolicy;
import org.glowroot.agent.embedded.shaded.org.owasp.html.FilterUrlByProtocolAttributePolicy;
import org.glowroot.agent.embedded.shaded.org.owasp.html.Strings;

final class StandardUrlAttributePolicy
implements AttributePolicy {
    static final StandardUrlAttributePolicy INSTANCE = new StandardUrlAttributePolicy();

    private StandardUrlAttributePolicy() {
    }

    @Override
    public String apply(String elementName, String attributeName, String value) {
        String url = Strings.stripHtmlSpaces(value);
        int n = url.length();
        block9: for (int i = 0; i < n; ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    break block9;
                }
                case ':': {
                    switch (i) {
                        case 4: {
                            if (Strings.regionMatchesIgnoreCase("http", 0, url, 0, 4)) break block9;
                            return null;
                        }
                        case 5: {
                            if (Strings.regionMatchesIgnoreCase("https", 0, url, 0, 5)) break block9;
                            return null;
                        }
                        case 6: {
                            if (Strings.regionMatchesIgnoreCase("mailto", 0, url, 0, 6)) break block9;
                            return null;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                default: {
                    continue block9;
                }
            }
        }
        return FilterUrlByProtocolAttributePolicy.normalizeUri(url);
    }
}

