/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.message.TraceSystem;
import org.glowroot.agent.embedded.shaded.org.h2.store.FileLock;
import org.glowroot.agent.embedded.shaded.org.h2.store.fs.FilePath;
import org.glowroot.agent.embedded.shaded.org.h2.store.fs.FileUtils;
import org.glowroot.agent.embedded.shaded.org.h2.util.New;
import org.glowroot.agent.embedded.sql.SQLException;

public class FileLister {
    public static void tryUnlockDatabase(List<String> list, String string) throws SQLException {
        for (String string2 : list) {
            Object object;
            if (string2.endsWith(".lock.db")) {
                object = new FileLock(new TraceSystem(null), string2, 1000);
                try {
                    ((FileLock)object).lock(1);
                    ((FileLock)object).unlock();
                    continue;
                }
                catch (DbException dbException) {
                    throw DbException.get(90133, string).getSQLException();
                }
            }
            if (!string2.endsWith(".mv.db")) continue;
            object = null;
            try {
                object = FilePath.get(string2).open("r");
                java.nio.channels.FileLock fileLock = ((FileChannel)object).tryLock(0L, Long.MAX_VALUE, true);
                fileLock.release();
            }
            catch (Exception exception) {
                throw DbException.get(90133, exception, string).getSQLException();
            }
            finally {
                if (object == null) continue;
                try {
                    ((AbstractInterruptibleChannel)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getDir(String string) {
        if (string == null || string.equals("")) {
            return ".";
        }
        return FileUtils.toRealPath(string);
    }

    public static ArrayList<String> getDatabaseFiles(String string, String string2, boolean bl) {
        ArrayList<String> arrayList = New.arrayList();
        String string3 = string2 == null ? null : FileUtils.toRealPath(string + "/" + string2) + ".";
        for (String string4 : FileUtils.newDirectoryStream(string)) {
            boolean bl2 = false;
            if (string4.endsWith(".lobs.db")) {
                if (string3 == null || string4.startsWith(string3)) {
                    arrayList.addAll(FileLister.getDatabaseFiles(string4, null, bl));
                    bl2 = true;
                }
            } else if (string4.endsWith(".lob.db")) {
                bl2 = true;
            } else if (string4.endsWith(".h2.db")) {
                bl2 = true;
            } else if (string4.endsWith(".mv.db")) {
                bl2 = true;
            } else if (bl) {
                if (string4.endsWith(".lock.db")) {
                    bl2 = true;
                } else if (string4.endsWith(".temp.db")) {
                    bl2 = true;
                } else if (string4.endsWith(".trace.db")) {
                    bl2 = true;
                }
            }
            if (!bl2 || string2 != null && !string4.startsWith(string3)) continue;
            String string5 = string4;
            arrayList.add(string5);
        }
        return arrayList;
    }
}

